/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementFacadeImpl;
import org.openqa.selenium.support.ui.Select;

class DropdownDeselector {
    private final WebElementFacadeImpl webElementFacade;

    public DropdownDeselector(WebElementFacadeImpl webElementFacade) {
        this.webElementFacade = webElementFacade;
    }

    public WebElementFacade all() {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.deselectAll();
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public WebElementFacade byVisibleText(String label) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.deselectByVisibleText(label);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public WebElementFacade byValue(String value) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.deselectByValue(value);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }

    public WebElementFacade byIndex(int indexValue) {
        if (this.webElementFacade.driverIsDisabled()) {
            return this.webElementFacade;
        }
        this.webElementFacade.waitUntilElementAvailable();
        Select select = new Select(this.webElementFacade.getElement());
        select.deselectByIndex(indexValue);
        this.webElementFacade.notifyScreenChange();
        return this.webElementFacade;
    }
}

