/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

class SetAppropriateSaucelabsPlatformVersion {
    private final DesiredCapabilities capabilities;
    private static String DEFAULT_PLATFORM = "Windows 10";
    private static Map<String, String> OS_PLATFORM_NAMES = new HashMap<String, String>();

    public SetAppropriateSaucelabsPlatformVersion(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public static SetAppropriateSaucelabsPlatformVersion inCapabilities(DesiredCapabilities capabilities) {
        return new SetAppropriateSaucelabsPlatformVersion(capabilities);
    }

    public void from(EnvironmentVariables environmentVariables) {
        String platformValue = ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(environmentVariables, DEFAULT_PLATFORM).toLowerCase();
        if (StringUtils.isEmpty((CharSequence)platformValue)) {
            return;
        }
        this.capabilities.setCapability("platform", OS_PLATFORM_NAMES.getOrDefault(platformValue, platformValue));
    }

    static {
        OS_PLATFORM_NAMES.put("snowleopard", "OS X 10.6");
        OS_PLATFORM_NAMES.put("snow leopard", "OS X 10.6");
        OS_PLATFORM_NAMES.put("mountainlion", "OS X 10.8");
        OS_PLATFORM_NAMES.put("mountain lion", "OS X 10.8");
        OS_PLATFORM_NAMES.put("mavericks", "OS X 10.9");
        OS_PLATFORM_NAMES.put("yosemite", "OS X 10.10");
        OS_PLATFORM_NAMES.put("elcapitan", "OS X 10.11");
        OS_PLATFORM_NAMES.put("el capitan", "OS X 10.11");
        OS_PLATFORM_NAMES.put("sierra", "macOS 10.12");
        OS_PLATFORM_NAMES.put("high sierra", "macOS 10.13");
        OS_PLATFORM_NAMES.put("mojave", "macOS 10.14");
        OS_PLATFORM_NAMES.put("catalina", "macOS 10.15");
        OS_PLATFORM_NAMES.put("big sur", "macOS 11");
    }
}

