/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.annotations.findby;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public abstract class By
extends org.openqa.selenium.By {
    public static By sclocator(String scLocator) {
        Preconditions.checkNotNull((Object)scLocator);
        return new ByScLocator(scLocator);
    }

    public static By jquery(String jQuerySelector) {
        Preconditions.checkNotNull((Object)jQuerySelector);
        return new ByjQuerySelector(jQuerySelector);
    }

    public static By buttonText(String text) {
        Preconditions.checkNotNull((Object)text);
        return new ByButtonTextSelector(text);
    }

    public static class ByScLocator
    extends By {
        private final String scLocator;

        public ByScLocator(String scLocator) {
            this.scLocator = scLocator;
        }

        public List<WebElement> findElements(SearchContext context) {
            throw new IllegalArgumentException("SmartGWT does not provide the functionality to find multiple elements");
        }

        public WebElement findElement(SearchContext context) {
            block3: {
                try {
                    WebElement element = (WebElement)((JavascriptExecutor)context).executeScript("return isc.AutoTest.getElement(arguments[0]);", new Object[]{this.scLocator});
                    if (element != null) {
                        return element;
                    }
                }
                catch (WebDriverException e) {
                    if (!((Boolean)((JavascriptExecutor)context).executeScript("return (typeof isc == 'undefined')", new Object[0])).booleanValue()) break block3;
                    throw new NoSuchElementException("Not a SmartGWT page. Cannot locate element using SmartGTW locator " + this.toString());
                }
            }
            throw new NoSuchElementException("Cannot locate element using " + this.toString());
        }

        public String toString() {
            return "By.sclocator: " + this.scLocator;
        }
    }

    public static class ByjQuerySelector
    extends By {
        private final String jQuerySelector;

        public ByjQuerySelector(String jQuerySelector) {
            this.jQuerySelector = jQuerySelector;
        }

        public List<WebElement> findElements(SearchContext context) {
            List elements = (List)((JavascriptExecutor)context).executeScript("var elements = $(arguments[0]).get(); return ((elements.length) ? elements : null)", new Object[]{this.jQuerySelector});
            if (elements != null) {
                return elements;
            }
            throw new NoSuchElementException("Cannot locate elements using " + this.toString());
        }

        public WebElement findElement(SearchContext context) {
            WebElement element = (WebElement)((JavascriptExecutor)context).executeScript("return $(arguments[0]).get(0)", new Object[]{this.jQuerySelector});
            if (element != null) {
                return element;
            }
            throw new NoSuchElementException("Cannot locate element using " + this.toString());
        }

        public String toString() {
            return "By.jQuerySelector: " + this.jQuerySelector;
        }
    }

    public static class ByButtonTextSelector
    extends By {
        String buttonLabel;

        public ByButtonTextSelector(String buttonLabel) {
            this.buttonLabel = buttonLabel;
        }

        public List<WebElement> findElements(SearchContext context) {
            return context.findElements(this.byXpathforButtonWithLabel(this.buttonLabel));
        }

        public WebElement findElement(SearchContext context) {
            WebElement element = context.findElement(this.byXpathforButtonWithLabel(this.buttonLabel));
            if (element != null) {
                return element;
            }
            throw new NoSuchElementException("Cannot locate element using " + this.toString());
        }

        private org.openqa.selenium.By byXpathforButtonWithLabel(String buttonLabel) {
            return By.xpath((String)String.format("//*[normalize-space(.)=\"%s\"]", buttonLabel));
        }

        public String toString() {
            return "By.buttonText: " + this.buttonLabel;
        }
    }
}

