/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.BrowserStackDriverBuilder;
import net.serenitybdd.core.webdriver.driverproviders.DefaultRemoteDriver;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverBuilder;
import net.serenitybdd.core.webdriver.driverproviders.RemoteWebdriverStub;
import net.serenitybdd.core.webdriver.driverproviders.SaucelabsDriverBuilder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;

public class RemoteDriverProvider
implements DriverProvider {
    private final FixtureProviderService fixtureProviderService;

    public RemoteDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
    }

    private Map<RemoteDriverType, RemoteDriverBuilder> driverBuildersFor(EnvironmentVariables environmentVariables) {
        HashMap<RemoteDriverType, RemoteDriverBuilder> driverBuilders = new HashMap<RemoteDriverType, RemoteDriverBuilder>();
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        DriverCapabilities remoteDriverCapabilities = new DriverCapabilities(environmentVariables, enhancer);
        driverBuilders.put(RemoteDriverType.SAUCELABS, new SaucelabsDriverBuilder(environmentVariables, remoteDriverCapabilities));
        driverBuilders.put(RemoteDriverType.BROWSERSTACK, new BrowserStackDriverBuilder(environmentVariables, remoteDriverCapabilities));
        driverBuilders.put(RemoteDriverType.DEFAULT, new DefaultRemoteDriver(environmentVariables, remoteDriverCapabilities));
        return driverBuilders;
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) throws MalformedURLException {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return RemoteWebdriverStub.from(environmentVariables);
        }
        WebDriver driver = this.driverBuildersFor(environmentVariables).get((Object)this.remoteDriverType(environmentVariables)).buildWithOptions(options);
        return new Augmenter().augment(driver);
    }

    private RemoteDriverType remoteDriverType(EnvironmentVariables environmentVariables) {
        if (this.saucelabsUrlIsDefined(environmentVariables)) {
            return RemoteDriverType.SAUCELABS;
        }
        return RemoteDriverType.DEFAULT;
    }

    private boolean saucelabsUrlIsDefined(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_URL.from(environmentVariables));
    }

    private boolean browserStackUrlIsDefined(EnvironmentVariables environmentVariables) {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.BROWSERSTACK_URL.from(environmentVariables));
    }

    static enum RemoteDriverType {
        SAUCELABS,
        BROWSERSTACK,
        DEFAULT;

    }
}

