/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.appium;

import io.appium.java_client.remote.AndroidMobileCapabilityType;
import io.appium.java_client.remote.IOSMobileCapabilityType;
import io.appium.java_client.remote.MobileCapabilityType;
import io.appium.java_client.remote.YouiEngineCapabilityType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PathProcessor;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.OptionsMap;
import net.thucydides.core.webdriver.ThucydidesConfigurationException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppiumConfiguration.class);
    private static final String DEFAULT_URL = "http://127.0.0.1:4723/wd/hub";
    private static final Predicate<String> ACCEPTED_W3C_PATTERNS = new AcceptedW3CCapabilityKeys();
    private static final List<String> APPIUM_SUPPORTED_CAPABILITIES = AppiumConfiguration.collectAppiumCapabilities();
    private final EnvironmentVariables environmentVariables;

    private AppiumConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static AppiumConfiguration from(EnvironmentVariables environmentVariables) {
        return new AppiumConfiguration(environmentVariables);
    }

    public MobilePlatform getTargetPlatform(WebDriver driver) {
        String PLATFORM_NAME = "platformName";
        try {
            Capabilities caps = RemoteDriver.of(driver).getCapabilities();
            if (caps.getCapabilityNames().contains(PLATFORM_NAME)) {
                return MobilePlatform.valueOf(caps.getCapability(PLATFORM_NAME).toString().toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Platform was not a MobilePlatform. Falling back to other platform definitions.");
        }
        catch (ClassCastException e) {
            LOGGER.debug("The driver could not be cast to RemoteWebDriver. Falling back to other platform definitions.");
        }
        return this.getTargetPlatform();
    }

    public MobilePlatform getTargetPlatform() {
        Optional<MobilePlatform> contextPlatform = Stream.of(this.definedContext()).filter(platform -> platform.isDefined).findFirst();
        if (contextPlatform.isPresent()) {
            return contextPlatform.get();
        }
        return Stream.of(this.definedTargetPlatform()).filter(platform -> platform.isDefined).findFirst().orElseThrow(() -> new ThucydidesConfigurationException("The appium.platformName needs to be specified (either IOS or ANDROID)"));
    }

    public MobilePlatform definedTargetPlatform() {
        String targetPlatform = ThucydidesSystemProperty.APPIUM_PLATFORMNAME.from(this.environmentVariables, "NONE");
        try {
            return MobilePlatform.valueOf(targetPlatform.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ThucydidesConfigurationException("Illegal appium.platformName value (needs to be either IOS or ANDROID):" + targetPlatform);
        }
    }

    public MobilePlatform definedContext() {
        String targetPlatform = ThucydidesSystemProperty.CONTEXT.from(this.environmentVariables, "NONE");
        try {
            return MobilePlatform.valueOf(targetPlatform.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("The provided context ({}) could not be used as the MobilePlatform", (Object)targetPlatform);
            return MobilePlatform.NONE;
        }
    }

    public URL getUrl() {
        String url = ThucydidesSystemProperty.APPIUM_HUB.from(this.environmentVariables, DEFAULT_URL);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ThucydidesConfigurationException("The appium.hub URL needs to be specified");
        }
    }

    public DesiredCapabilities getCapabilities() {
        return this.getCapabilities("");
    }

    public DesiredCapabilities getCapabilities(String options) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        SetProxyConfiguration.from(this.environmentVariables).in(capabilities);
        AddLoggingPreferences.from(this.environmentVariables).to(capabilities);
        Properties appiumProperties = this.getProperties(options);
        for (Object key : appiumProperties.keySet()) {
            capabilities.setCapability(key.toString(), appiumProperties.getProperty(key.toString()));
        }
        if (!ThucydidesSystemProperty.APPIUM_PROCESS_DESIRED_CAPABILITIES.booleanFrom(this.environmentVariables, Boolean.FALSE).booleanValue()) {
            return capabilities;
        }
        List<String> additionalAppiumCapabilities = this.getAdditionalAppiumCapabilities();
        DesiredCapabilities processedCapabilities = new DesiredCapabilities();
        for (String capabilityName : capabilities.getCapabilityNames()) {
            if (ACCEPTED_W3C_PATTERNS.test(capabilityName) || APPIUM_SUPPORTED_CAPABILITIES.contains(capabilityName)) {
                processedCapabilities.setCapability(capabilityName, capabilities.getCapability(capabilityName));
                continue;
            }
            if (additionalAppiumCapabilities.contains(capabilityName)) {
                LOGGER.info("appium: prefix added to capability {}", (Object)capabilityName);
                processedCapabilities.setCapability("appium:" + capabilityName, capabilities.getCapability(capabilityName));
                continue;
            }
            LOGGER.warn("{} capability is not discovered in the list of supported by w3c or Appium. If it is required then it should be listed in {@link ThucydidesSystemProperty#APPIUM_ADDITIONAL_CAPABILITIES}", (Object)capabilityName);
        }
        return processedCapabilities;
    }

    public Properties getProperties(String options) {
        return this.appiumPropertiesFrom(this.environmentVariables, options);
    }

    private Properties appiumPropertiesFrom(EnvironmentVariables environmentVariables, String options) {
        Properties appiumProperties = new Properties();
        String env = environmentVariables.getProperty("environment", "default");
        String regex = String.format("environments\\.(all|%s)\\.appium", env);
        List appiumKeys = environmentVariables.getKeys().stream().map(key -> key.replaceFirst(regex, "appium")).distinct().filter(key -> key.startsWith("appium.")).collect(Collectors.toList());
        for (String key2 : appiumKeys) {
            String specifiedAppPath = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{key2}).orElse("");
            String value = this.isAppProperty(key2) ? this.appPathFrom(specifiedAppPath) : specifiedAppPath;
            String simplifiedKey = key2.replace("appium.", "");
            appiumProperties.setProperty(simplifiedKey, value.trim());
        }
        Map<String, String> optionsMap = OptionsMap.from(options);
        for (String key3 : optionsMap.keySet()) {
            appiumProperties.setProperty(key3, optionsMap.get(key3));
        }
        this.ensureAppOrBrowserPathDefinedIn(appiumProperties);
        return appiumProperties;
    }

    private void ensureAppOrBrowserPathDefinedIn(Properties appiumProperties) {
        if (!appiumProperties.containsKey("app") && !appiumProperties.containsKey("browserName")) {
            throw new ThucydidesConfigurationException("The browser under test or path to the app needs to be provided in the appium.app or appium.browserName property.");
        }
    }

    private String appPathFrom(String propertyValue) {
        return new PathProcessor().normalize(propertyValue);
    }

    private boolean isAppProperty(String key) {
        return key.equals("appium.app");
    }

    public boolean isDefined() {
        return this.getTargetPlatform() != MobilePlatform.NONE;
    }

    private static List<String> collectAppiumCapabilities() {
        Class[] capabilityClasses = new Class[]{MobileCapabilityType.class, AndroidMobileCapabilityType.class, IOSMobileCapabilityType.class, YouiEngineCapabilityType.class};
        ArrayList mobileCapabilities = new ArrayList();
        for (Class capsClass : capabilityClasses) {
            Stream.of(capsClass.getDeclaredFields()).map(f -> {
                f.setAccessible(true);
                try {
                    return f.get(capsClass).toString();
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }).forEach(mobileCapabilities::add);
        }
        return mobileCapabilities.stream().distinct().collect(Collectors.toList());
    }

    private List<String> getAdditionalAppiumCapabilities() {
        String capabilities = ThucydidesSystemProperty.APPIUM_ADDITIONAL_CAPABILITIES.from(this.environmentVariables, "");
        return Stream.of(capabilities.split(",")).map(String::trim).filter(v -> !v.isEmpty()).distinct().collect(Collectors.toList());
    }
}

