/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ScreenshotAndHtmlSource {
    private final File screenshotFile;
    private final File htmlSource;

    public ScreenshotAndHtmlSource(String screenshotName, String sourcecodeName) {
        this.screenshotFile = new File(screenshotName);
        this.htmlSource = sourcecodeName != null ? new File(sourcecodeName) : null;
    }

    public ScreenshotAndHtmlSource(File screenshotFile, File sourcecode) {
        this.screenshotFile = screenshotFile;
        this.htmlSource = sourcecode;
    }

    public String getScreenshotName() {
        return this.screenshotFile.getName();
    }

    public String getHtmlSourceName() {
        if (this.htmlSource == null) {
            return null;
        }
        return this.htmlSource.getName();
    }

    public ScreenshotAndHtmlSource(File screenshotFile) {
        this(screenshotFile, null);
    }

    public File getScreenshotFile() {
        return this.screenshotFile;
    }

    public Optional<File> getHtmlSource() {
        return Optional.fromNullable((Object)this.htmlSource);
    }

    public boolean wasTaken() {
        return this.screenshotFile != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScreenshotAndHtmlSource)) {
            return false;
        }
        ScreenshotAndHtmlSource that = (ScreenshotAndHtmlSource)o;
        if (this.screenshotFile == null) {
            return that.screenshotFile == null;
        }
        if (that.screenshotFile == null) {
            return this.screenshotFile == null;
        }
        try {
            return FileUtils.contentEquals((File)this.screenshotFile, (File)that.screenshotFile);
        }
        catch (IOException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.screenshotFile != null ? this.screenshotFile.hashCode() : 0;
    }

    public boolean hasIdenticalScreenshotsAs(ScreenshotAndHtmlSource anotherScreenshotAndHtmlSource) {
        if (this.hasNoScreenshot() || anotherScreenshotAndHtmlSource.hasNoScreenshot()) {
            return false;
        }
        return this.getScreenshotFile().getName().equals(anotherScreenshotAndHtmlSource.getScreenshotFile().getName());
    }

    public File getScreenshotFile(File screenshotTargetDirectory) {
        return new File(screenshotTargetDirectory, this.getScreenshotFile().getName());
    }

    public boolean hasNoScreenshot() {
        return this.getScreenshotFile() == null;
    }
}

