/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.tomcat;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.tomcat.TomcatServerAdapter;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class TomcatLogbackAccessEvent
extends AbstractLogbackAccessEvent {
    private boolean requestAttributesEnabled;
    private final LocalPort localPort = new LocalPort();
    private final RemoteAddr remoteAddr = new RemoteAddr();
    private final RemoteHost remoteHost = new RemoteHost();
    private final Protocol protocol = new Protocol();

    public TomcatLogbackAccessEvent(Request request, Response response) {
        super((HttpServletRequest)request, (HttpServletResponse)response, (ch.qos.logback.access.spi.ServerAdapter)new ServerAdapter(request, response));
    }

    @Override
    public int getLocalPort() {
        return (Integer)this.localPort.get();
    }

    public String getRemoteAddr() {
        return (String)this.remoteAddr.get();
    }

    public String getRemoteHost() {
        return (String)this.remoteHost.get();
    }

    public String getProtocol() {
        return (String)this.protocol.get();
    }

    public boolean isRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = requestAttributesEnabled;
    }

    private static class ServerAdapter
    extends TomcatServerAdapter {
        private final Request request;
        private final Response response;

        private ServerAdapter(Request request, Response response) {
            super(request, response);
            this.request = request;
            this.response = response;
        }

        public long getContentLength() {
            long length = this.response.getBytesWritten(false);
            if (length > 0L) {
                return length;
            }
            Long start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            Long end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            if (start != null && end != null) {
                return end - start;
            }
            return super.getContentLength();
        }
    }

    private class Protocol
    extends AbstractLogbackAccessEvent.AbstractOverridenAttribute<String> {
        private Protocol() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(TomcatLogbackAccessEvent.this).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("org.apache.catalina.AccessLog.Protocol"));
        }

        @Override
        protected String getOriginalValue() {
            return TomcatLogbackAccessEvent.super.getProtocol();
        }
    }

    private class RemoteHost
    extends AbstractLogbackAccessEvent.AbstractOverridenAttribute<String> {
        private RemoteHost() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(TomcatLogbackAccessEvent.this).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("org.apache.catalina.AccessLog.RemoteHost"));
        }

        @Override
        protected String getOriginalValue() {
            return TomcatLogbackAccessEvent.super.getRemoteHost();
        }
    }

    private class RemoteAddr
    extends AbstractLogbackAccessEvent.AbstractOverridenAttribute<String> {
        private RemoteAddr() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(TomcatLogbackAccessEvent.this).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("org.apache.catalina.AccessLog.RemoteAddr"));
        }

        @Override
        protected String getOriginalValue() {
            return TomcatLogbackAccessEvent.super.getRemoteAddr();
        }
    }

    private class LocalPort
    extends AbstractLogbackAccessEvent.AbstractOverridenAttribute<Integer> {
        private LocalPort() {
        }

        @Override
        protected Optional<Integer> evaluateValueToOverride() {
            return Optional.of(TomcatLogbackAccessEvent.this).filter(AbstractLogbackAccessEvent::isUseServerPortInsteadOfLocalPort).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (Integer)request.getAttribute("org.apache.catalina.AccessLog.ServerPort"));
        }

        @Override
        protected Integer getOriginalValue() {
            return TomcatLogbackAccessEvent.super.getLocalPort();
        }
    }
}

