/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import java.io.Serializable;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessSecurityAttributesSaveFilter;

public abstract class AbstractLogbackAccessEvent
extends AccessEvent {
    private boolean useServerPortInsteadOfLocalPort;
    private final LocalPort localPort = new LocalPort();
    private final RemoteUser remoteUser = new RemoteUser();

    public AbstractLogbackAccessEvent(HttpServletRequest request, HttpServletResponse response, ServerAdapter adapter) {
        super(request, response, adapter);
        this.setThreadName(Thread.currentThread().getName());
    }

    public int getLocalPort() {
        return (Integer)this.localPort.get();
    }

    public String getRemoteUser() {
        return (String)this.remoteUser.get();
    }

    public boolean isUseServerPortInsteadOfLocalPort() {
        return this.useServerPortInsteadOfLocalPort;
    }

    public void setUseServerPortInsteadOfLocalPort(boolean useServerPortInsteadOfLocalPort) {
        this.useServerPortInsteadOfLocalPort = useServerPortInsteadOfLocalPort;
    }

    private class RemoteUser
    extends AbstractOverridenAttribute<String> {
        private RemoteUser() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(AbstractLogbackAccessEvent.this).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute(LogbackAccessSecurityAttributesSaveFilter.REMOTE_USER_ATTRIBUTE_NAME));
        }

        @Override
        protected String getOriginalValue() {
            return AbstractLogbackAccessEvent.super.getRemoteUser();
        }
    }

    private class LocalPort
    extends AbstractOverridenAttribute<Integer> {
        private LocalPort() {
        }

        @Override
        protected Optional<Integer> evaluateValueToOverride() {
            return Optional.of(AbstractLogbackAccessEvent.this).filter(AbstractLogbackAccessEvent::isUseServerPortInsteadOfLocalPort).map(AccessEvent::getRequest).map(ServletRequest::getServerPort);
        }

        @Override
        protected Integer getOriginalValue() {
            return AbstractLogbackAccessEvent.super.getLocalPort();
        }
    }

    protected static abstract class AbstractOverridenAttribute<T extends Serializable>
    implements Serializable {
        private boolean evaluated;
        private T value;

        protected AbstractOverridenAttribute() {
        }

        public T get() {
            if (!this.evaluated) {
                this.value = this.evaluateValueToOverride().orElse(null);
                this.evaluated = true;
            }
            return (T)Optional.ofNullable(this.value).orElseGet(this::getOriginalValue);
        }

        protected abstract Optional<T> evaluateValueToOverride();

        protected abstract T getOriginalValue();
    }
}

