/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.undertow;

import ch.qos.logback.access.spi.AccessEvent;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessEvent;
import net.rakugakibox.spring.boot.logback.access.AbstractOverridenAttribute;

public class UndertowLogbackAccessEvent
extends AbstractLogbackAccessEvent {
    private final RequestURI requestURI = new RequestURI();
    private final QueryString queryString = new QueryString();

    public UndertowLogbackAccessEvent(HttpServerExchange exchange) {
        super(UndertowLogbackAccessEvent.extractHttpServletRequest(exchange), UndertowLogbackAccessEvent.extractHttpServletResponse(exchange), new ServerAdapter(exchange));
    }

    private static HttpServletRequest extractHttpServletRequest(HttpServerExchange exchange) {
        ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return (HttpServletRequest)context.getServletRequest();
    }

    private static HttpServletResponse extractHttpServletResponse(HttpServerExchange exchange) {
        ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return (HttpServletResponse)context.getServletResponse();
    }

    public String getRequestURI() {
        return (String)this.requestURI.get();
    }

    public String getQueryString() {
        return (String)this.queryString.get();
    }

    public String getRequestURL() {
        return this.getMethod() + ' ' + this.getRequestURI() + this.getQueryString() + ' ' + this.getProtocol();
    }

    private class QueryString
    extends AbstractOverridenAttribute<String> {
        private QueryString() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(UndertowLogbackAccessEvent.this).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("javax.servlet.forward.query_string")).filter(query -> !query.isEmpty()).map(query -> '?' + query);
        }

        @Override
        protected String getOriginalValue() {
            return UndertowLogbackAccessEvent.super.getQueryString();
        }
    }

    private class RequestURI
    extends AbstractOverridenAttribute<String> {
        private RequestURI() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(UndertowLogbackAccessEvent.this).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("javax.servlet.forward.request_uri"));
        }

        @Override
        protected String getOriginalValue() {
            return UndertowLogbackAccessEvent.super.getRequestURI();
        }
    }

    private static class ServerAdapter
    implements ch.qos.logback.access.spi.ServerAdapter {
        private final HttpServerExchange exchange;

        private ServerAdapter(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        public long getRequestTimestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            long nanoTime = System.nanoTime();
            long requestStartTime = this.exchange.getRequestStartTime();
            return currentTimeMillis - TimeUnit.NANOSECONDS.toMillis(nanoTime - requestStartTime);
        }

        public int getStatusCode() {
            return this.exchange.getStatusCode();
        }

        public long getContentLength() {
            return this.exchange.getResponseBytesSent();
        }

        public Map<String, String> buildResponseHeaderMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            HeaderMap headers = this.exchange.getResponseHeaders();
            for (HeaderValues header : headers) {
                result.put(header.getHeaderName().toString(), header.getFirst());
            }
            return result;
        }
    }
}

