/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.threadlocal;

import net.openhft.lang.threadlocal.StatefulCopyable;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

public abstract class Provider<T> {
    public static <T> Provider<T> of(Class<T> tClass) {
        if (StatefulCopyable.class.isAssignableFrom(tClass)) {
            return StatefulProvider.INSTANCE;
        }
        return StatelessProvider.INSTANCE;
    }

    public abstract T get(ThreadLocalCopies var1, T var2);

    public abstract ThreadLocalCopies getCopies(ThreadLocalCopies var1);

    private static final class StatelessProvider<M>
    extends Provider<M> {
        private static final Provider INSTANCE = new StatelessProvider();

        private StatelessProvider() {
        }

        @Override
        public M get(ThreadLocalCopies copies, M original) {
            return original;
        }

        @Override
        public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            return copies;
        }
    }

    private static final class StatefulProvider<T extends StatefulCopyable<T>>
    extends Provider<T> {
        private static final Provider INSTANCE = new StatefulProvider();

        private StatefulProvider() {
        }

        @Override
        public ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
            if (copies != null) {
                return copies;
            }
            return ThreadLocalCopies.get();
        }

        @Override
        public T get(ThreadLocalCopies copies, T original) {
            return this.get(copies, original, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T get(ThreadLocalCopies copies, T original, boolean syncPut) {
            Object id = original.stateIdentity();
            int m = copies.mask;
            Object[] tab = copies.table;
            int i = System.identityHashCode(id) & m;
            Object idInTable;
            while ((idInTable = tab[i]) != id) {
                if (idInTable == null) {
                    if (syncPut) {
                        if (copies.currentlyAccessed.compareAndSet(false, true)) {
                            try {
                                T t = this.get(copies, original, false);
                                return t;
                            }
                            finally {
                                copies.currentlyAccessed.set(false);
                            }
                        }
                        throw new IllegalStateException("Concurrent or recursive access to ThreadLocalCopies is not allowed");
                    }
                    tab[i] = id;
                    Object copy = original.copy();
                    tab[i + 1] = copy;
                    copies.postInsert();
                    return (T)copy;
                }
                i = i + 2 & m;
            }
            return (T)((StatefulCopyable)tab[i + 1]);
        }
    }
}

