/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.openhft.lang.io.FileLifecycleListener;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedFile;
import net.openhft.lang.io.VanillaMappedMode;
import net.openhft.lang.io.VanillaMappedResource;

public class VanillaMappedBlocks
implements VanillaMappedResource {
    private final VanillaMappedFile mappedFile;
    private final List<VanillaMappedBytes> bytes;
    private final long blockSize;
    private final FileLifecycleListener fileLifecycleListener;
    private VanillaMappedBytes mb0;
    private VanillaMappedBytes mb1;

    public VanillaMappedBlocks(File path, VanillaMappedMode mode, long blockSize, long overlapSize) throws IOException {
        this(path, mode, blockSize + overlapSize, null);
    }

    public VanillaMappedBlocks(File path, VanillaMappedMode mode, long blockSize, FileLifecycleListener fileLifecycleListener) throws IOException {
        this.fileLifecycleListener = fileLifecycleListener;
        this.mappedFile = new VanillaMappedFile(path, mode, -1L, fileLifecycleListener);
        this.bytes = new ArrayList<VanillaMappedBytes>();
        this.blockSize = blockSize;
        this.mb0 = null;
        this.mb1 = null;
    }

    public synchronized VanillaMappedBytes acquire(long index) throws IOException {
        if (this.mb0 != null && this.mb0.index() == index) {
            this.mb0.reserve();
            return this.mb0;
        }
        if (this.mb1 != null && this.mb1.index() == index) {
            this.mb1.reserve();
            return this.mb1;
        }
        return this.acquire0(index);
    }

    protected VanillaMappedBytes acquire0(long index) throws IOException {
        if (this.mb1 != null) {
            this.mb1.release();
        }
        this.mb1 = this.mb0;
        this.mb0 = this.mappedFile.bytes(index * this.blockSize, this.blockSize, index);
        this.mb0.reserve();
        this.bytes.add(this.mb0);
        for (int i = this.bytes.size() - 1; i >= 0; --i) {
            if (!this.bytes.get(i).unmapped()) continue;
            this.bytes.remove(i);
        }
        return this.mb0;
    }

    @Override
    public String path() {
        return this.mappedFile.path();
    }

    @Override
    public synchronized long size() {
        return this.mappedFile.size();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.mb0 != null && !this.mb0.unmapped()) {
            this.mb0.release();
            this.mb0 = null;
        }
        if (this.mb1 != null && !this.mb1.unmapped()) {
            this.mb1.release();
            this.mb1 = null;
        }
        for (int i = this.bytes.size() - 1; i >= 0; --i) {
            this.bytes.get(i).cleanup();
        }
        this.bytes.clear();
        this.mappedFile.close();
    }

    public static VanillaMappedBlocks readWrite(File path, long size) throws IOException {
        return VanillaMappedBlocks.readWrite(path, size, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public static VanillaMappedBlocks readOnly(File path, long size) throws IOException {
        return VanillaMappedBlocks.readOnly(path, size, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public static VanillaMappedBlocks readWrite(File path, long size, FileLifecycleListener listener) throws IOException {
        return new VanillaMappedBlocks(path, VanillaMappedMode.RW, size, listener);
    }

    public static VanillaMappedBlocks readOnly(File path, long size, FileLifecycleListener listener) throws IOException {
        return new VanillaMappedBlocks(path, VanillaMappedMode.RO, size, listener);
    }
}

