/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel.impl;

import java.lang.reflect.Field;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.channel.impl.TCPChronicleChannel;
import org.jetbrains.annotations.NotNull;

public class WireExchanger
extends SimpleCloseable
implements MarshallableOut {
    static final int USED_MASK = 1;
    static final int FREE = 0;
    static final int LOCKED = 16;
    static final int DIRTY = 256;
    static final int FREE0 = 0;
    static final int LOCKED0 = 16;
    static final int DIRTY0 = 256;
    static final int FREE1 = 1;
    static final int LOCKED1 = 17;
    static final int DIRTY1 = 257;
    private static final int INIT_CAPACITY = TCPChronicleChannel.CAPACITY;
    private static final long valueOffset;
    private static final Wire EMPTY_WIRE;
    private final Wire wire0;
    private final Wire wire1;
    private final WEDocumentContext writeContext = new WEDocumentContext();
    private int delay = 0;
    private volatile int value;

    public WireExchanger() {
        this(INIT_CAPACITY);
    }

    public @NotNull WireExchanger(int initCapacity) {
        this.wire0 = (Wire)WireType.BINARY_LIGHT.apply(Bytes.elasticByteBuffer((int)initCapacity));
        this.wire0.bytes().singleThreadedCheckDisabled(true);
        this.wire1 = (Wire)WireType.BINARY_LIGHT.apply(Bytes.elasticByteBuffer((int)initCapacity));
        this.wire1.bytes().singleThreadedCheckDisabled(true);
    }

    protected void performClose() {
        super.performClose();
        this.wire0.bytes().releaseLast();
        this.wire1.bytes().releaseLast();
    }

    public Wire acquireProducer() {
        int val = this.lock();
        int writeTo = val & 1;
        Wire wire = this.wireAt(writeTo);
        if (wire.bytes().readRemaining() <= (long)(INIT_CAPACITY / 2)) {
            if (this.delay > 1) {
                --this.delay;
            }
            return wire;
        }
        this.releaseProducer();
        return this.acquireProducer2();
    }

    @NotNull
    private Wire acquireProducer2() {
        Jvm.pause((long)this.delay++);
        int val2 = this.lock();
        int writeTo2 = val2 & 1;
        Wire wire2 = this.wireAt(writeTo2);
        long used = wire2.bytes().readRemaining();
        if (used > (long)INIT_CAPACITY * 4L / 5L) {
            double ratio = (double)used / (double)INIT_CAPACITY;
            Jvm.perf().on(this.getClass(), "Producer buffering " + (int)(100.0 * ratio) + "%");
        }
        return wire2;
    }

    public void releaseProducer() {
        int val2 = 0x100 | this.value & 1;
        UnsafeMemory.MEMORY.writeOrderedInt((Object)this, valueOffset, val2);
    }

    private Wire wireAt(int writeTo) {
        return writeTo == 0 ? this.wire0 : this.wire1;
    }

    public Wire acquireConsumer() {
        if ((this.value & 0x100) == 0) {
            return EMPTY_WIRE;
        }
        int val = this.lock();
        int writeTo = val & 1;
        int val2 = 0 | writeTo ^ 1;
        UnsafeMemory.MEMORY.writeOrderedInt((Object)this, valueOffset, val2);
        return this.wireAt(writeTo);
    }

    public int lock() throws IllegalStateException {
        long start = System.currentTimeMillis();
        while (true) {
            int val;
            if (((val = this.value) & 0x10) != 0) {
                if (System.currentTimeMillis() > start + 10000L) {
                    throw new IllegalStateException("timeout");
                }
            } else {
                int writeTo = val & 1;
                int val2 = 0x10 | writeTo;
                if (UnsafeMemory.MEMORY.compareAndSwapInt((Object)this, valueOffset, val, val2)) {
                    return val2;
                }
            }
            Jvm.nanoPause();
        }
    }

    public void releaseConsumer() {
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        Wire wire = this.acquireProducer();
        this.writeContext.wire(wire);
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        return this.writeContext.documentContext() != null && this.writeContext.isOpen() && this.writeContext.chainedElement() ? this.writeContext : this.writingDocument(metaData);
    }

    static {
        EMPTY_WIRE = (Wire)WireType.BINARY_LIGHT.apply(Bytes.from((String)""));
        try {
            valueOffset = UnsafeMemory.unsafeObjectFieldOffset((Field)WireExchanger.class.getDeclaredField("value"));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    class WEDocumentContext
    extends DocumentContextHolder
    implements WriteDocumentContext {
        private Wire wire;

        WEDocumentContext() {
        }

        @Override
        public void start(boolean metaData) {
            this.documentContext(this.wire.writingDocument(metaData));
        }

        @Override
        public boolean chainedElement() {
            return this.documentContext().chainedElement();
        }

        @Override
        public void chainedElement(boolean chainedElement) {
            this.documentContext().chainedElement(chainedElement);
        }

        @Override
        public WriteDocumentContext documentContext() {
            return (WriteDocumentContext)super.documentContext();
        }

        @Override
        public void close() {
            WriteDocumentContext dc = this.documentContext();
            dc.close();
            if (!dc.isNotComplete()) {
                this.documentContext(null);
                WireExchanger.this.releaseProducer();
            }
        }

        public void wire(Wire wire) {
            this.wire = wire;
        }
    }
}

