/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.fieldinfo;

import java.lang.reflect.Field;
import java.util.Objects;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.internal.fieldinfo.UnsafeFieldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectFieldInfo
extends UnsafeFieldInfo {
    public ObjectFieldInfo(String name, Class<?> type, BracketType bracketType, @NotNull Field field) {
        super(name, type, bracketType, field);
    }

    @Override
    @Nullable
    public Object get(Object object) {
        try {
            return UnsafeMemory.unsafeGetObject((Object)object, (long)this.getOffset());
        }
        catch (NoSuchFieldException e) {
            Jvm.debug().on(ObjectFieldInfo.class, (Throwable)e);
            return null;
        }
    }

    @Override
    public void set(Object object, Object value) throws IllegalArgumentException {
        Object value2 = ObjectUtils.convertTo((Class)this.type, (Object)value);
        try {
            UnsafeMemory.unsafePutObject((Object)object, (long)this.getOffset(), (Object)value2);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isEqual(Object a, Object b) {
        return Objects.deepEquals(this.get(a), this.get(b));
    }

    @Override
    public void copy(Object source, Object destination) {
        this.set(destination, this.get(source));
    }
}

