/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.stream;

import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToDoubleDocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import net.openhft.chronicle.wire.internal.stream.StreamsUtil;
import org.jetbrains.annotations.NotNull;

public final class Streams {
    private Streams() {
    }

    @NotNull
    public static <T> Stream<T> of(@NotNull MarshallableIn documentProvider, @NotNull DocumentExtractor<T> extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull(extractor);
        return StreamSupport.stream(Streams.spliterator(documentProvider, extractor), false);
    }

    @NotNull
    public static LongStream ofLong(@NotNull MarshallableIn documentProvider, @NotNull ToLongDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull((Object)extractor);
        return StreamSupport.longStream(Streams.spliteratorOfLong(documentProvider, extractor), false);
    }

    @NotNull
    public static DoubleStream ofDouble(@NotNull MarshallableIn documentProvider, @NotNull ToDoubleDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull((Object)extractor);
        return StreamSupport.doubleStream(Streams.spliteratorOfDouble(documentProvider, extractor), false);
    }

    @NotNull
    public static <T> Spliterator<T> spliterator(@NotNull MarshallableIn documentProvider, @NotNull DocumentExtractor<T> extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull(extractor);
        return new StreamsUtil.VanillaSpliterator<T>(Streams.iterator(documentProvider, extractor));
    }

    @NotNull
    public static Spliterator.OfLong spliteratorOfLong(@NotNull MarshallableIn documentProvider, @NotNull ToLongDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull((Object)extractor);
        return new StreamsUtil.VanillaSpliteratorOfLong(Streams.iteratorOfLong(documentProvider, extractor));
    }

    @NotNull
    public static Spliterator.OfDouble spliteratorOfDouble(@NotNull MarshallableIn documentProvider, @NotNull ToDoubleDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull((Object)extractor);
        return new StreamsUtil.VanillaSpliteratorOfDouble(Streams.iteratorOfDouble(documentProvider, extractor));
    }

    @NotNull
    public static <T> Iterator<T> iterator(@NotNull MarshallableIn documentProvider, @NotNull DocumentExtractor<T> extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull(extractor);
        return new StreamsUtil.ExcerptIterator<T>(documentProvider, extractor);
    }

    @NotNull
    public static PrimitiveIterator.OfLong iteratorOfLong(@NotNull MarshallableIn documentProvider, @NotNull ToLongDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull((Object)extractor);
        return new StreamsUtil.ExcerptIteratorOfLong(documentProvider, extractor);
    }

    @NotNull
    public static PrimitiveIterator.OfDouble iteratorOfDouble(@NotNull MarshallableIn documentProvider, @NotNull ToDoubleDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)documentProvider);
        ObjectUtils.requireNonNull((Object)extractor);
        return new StreamsUtil.ExcerptIteratorOfDouble(documentProvider, extractor);
    }
}

