/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.reduction;

import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.ExcerptListener;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToDoubleDocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import net.openhft.chronicle.wire.internal.reduction.ReductionUtil;
import org.jetbrains.annotations.NotNull;

public interface Reduction<T>
extends ExcerptListener {
    @Override
    public void onExcerpt(@NotNull Wire var1, @NonNegative long var2);

    @NotNull
    public T reduction();

    default public long accept(@NotNull MarshallableIn tailer) {
        ObjectUtils.requireNonNull((Object)tailer);
        return ReductionUtil.accept(tailer, this);
    }

    public static <E> ReductionBuilder<E> of(@NotNull DocumentExtractor<E> extractor) {
        ObjectUtils.requireNonNull(extractor);
        return new ReductionUtil.VanillaReductionBuilder<E>(extractor);
    }

    public static LongReductionBuilder ofLong(@NotNull ToLongDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)extractor);
        return new ReductionUtil.VanillaLongReductionBuilder(extractor);
    }

    public static DoubleReductionBuilder ofDouble(@NotNull ToDoubleDocumentExtractor extractor) {
        ObjectUtils.requireNonNull((Object)extractor);
        return new ReductionUtil.VanillaDoubleReductionBuilder(extractor);
    }

    public static interface DoubleReductionBuilder {
        public <A> Reduction<DoubleSupplier> reducing(@NotNull Supplier<A> var1, @NotNull ObjDoubleConsumer<A> var2, @NotNull ToDoubleFunction<A> var3);
    }

    public static interface LongReductionBuilder {
        public <A> Reduction<LongSupplier> reducing(@NotNull Supplier<A> var1, @NotNull ObjLongConsumer<A> var2, @NotNull ToLongFunction<A> var3);
    }

    public static interface ReductionBuilder<E> {
        public <A, R> Reduction<R> collecting(@NotNull Collector<E, A, ? extends R> var1);
    }
}

