/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.ValueIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScalarStrategy<T>
implements SerializationStrategy<T> {
    @NotNull
    final BiFunction<T, ValueIn, T> read;
    private final Class<T> type;

    ScalarStrategy(Class<T> type, @NotNull BiFunction<T, ValueIn, T> read) {
        this.type = type;
        this.read = read;
    }

    @NotNull
    static <T> ScalarStrategy<T> of(Class<T> clazz, @NotNull BiFunction<T, ValueIn, T> read) {
        return new ScalarStrategy<T>(clazz, read);
    }

    @Nullable
    static <T> ScalarStrategy<T> text(Class<T> clazz, @NotNull Function<String, T> func) {
        return new ScalarStrategy<Object>(clazz, (o, in) -> {
            String text = in.text();
            return text == null ? null : func.apply(text);
        });
    }

    @Override
    @NotNull
    public BracketType bracketType() {
        return BracketType.NONE;
    }

    @Override
    public T newInstance(Class type) {
        return (T)ObjectUtils.newInstance(this.type);
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    @Nullable
    public T readUsing(T using, @NotNull ValueIn in) {
        if (in.isNull()) {
            return null;
        }
        return this.read.apply(using, in);
    }

    @NotNull
    public String toString() {
        return "ScalarStrategy<" + this.type.getName() + ">";
    }
}

