/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set.replication;

import net.openhft.chronicle.hash.HashAbsentEntry;
import net.openhft.chronicle.hash.replication.DefaultEventualConsistencyStrategy;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.set.SetAbsentEntry;
import net.openhft.chronicle.set.SetEntry;
import net.openhft.chronicle.set.replication.SetRemoteQueryContext;

public interface SetRemoteOperations<K, R> {
    default public void remove(SetRemoteQueryContext<K, R> q) {
        SetEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification((ReplicableEntry)((Object)entry), q) == DefaultEventualConsistencyStrategy.AcceptanceDecision.ACCEPT) {
                q.remove(entry);
                ReplicableEntry replicableAbsentEntry = (ReplicableEntry)((Object)q.absentEntry());
                if (!1.$assertionsDisabled && replicableAbsentEntry == null) {
                    throw new AssertionError();
                }
                replicableAbsentEntry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
                if (q.remoteIdentifier() == q.currentNodeIdentifier()) {
                    replicableAbsentEntry.raiseChangedForAllExcept(q.remoteNodeIdentifier());
                    replicableAbsentEntry.dropChangedFor(q.remoteNodeIdentifier());
                } else {
                    replicableAbsentEntry.dropChanged();
                }
            }
        } else {
            ReplicableEntry replicableAbsentEntry;
            HashAbsentEntry absentEntry = q.absentEntry();
            if (!1.$assertionsDisabled && absentEntry == null) {
                throw new AssertionError();
            }
            if (!(absentEntry instanceof ReplicableEntry)) {
                absentEntry.doInsert();
                entry = q.entry();
                if (!1.$assertionsDisabled && entry == null) {
                    throw new AssertionError();
                }
                entry.doRemove();
                replicableAbsentEntry = (ReplicableEntry)((Object)q.absentEntry());
                if (!1.$assertionsDisabled && replicableAbsentEntry == null) {
                    throw new AssertionError();
                }
            } else {
                replicableAbsentEntry = (ReplicableEntry)((Object)absentEntry);
                if (DefaultEventualConsistencyStrategy.decideOnRemoteModification(replicableAbsentEntry, q) == DefaultEventualConsistencyStrategy.AcceptanceDecision.DISCARD) {
                    return;
                }
            }
            replicableAbsentEntry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
            if (q.remoteIdentifier() == q.currentNodeIdentifier()) {
                replicableAbsentEntry.raiseChangedForAllExcept(q.remoteNodeIdentifier());
                replicableAbsentEntry.dropChangedFor(q.remoteNodeIdentifier());
            } else {
                replicableAbsentEntry.dropChanged();
            }
        }
    }

    default public void put(SetRemoteQueryContext<K, R> q) {
        SetEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification((ReplicableEntry)((Object)entry), q) == DefaultEventualConsistencyStrategy.AcceptanceDecision.ACCEPT) {
                entry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
                if (q.remoteIdentifier() == q.currentNodeIdentifier()) {
                    entry.raiseChanged();
                } else {
                    entry.dropChanged();
                }
            }
        } else {
            HashAbsentEntry absentEntry = q.absentEntry();
            if (!1.$assertionsDisabled && absentEntry == null) {
                throw new AssertionError();
            }
            if (!(absentEntry instanceof ReplicableEntry) || DefaultEventualConsistencyStrategy.decideOnRemoteModification((ReplicableEntry)((Object)absentEntry), q) == DefaultEventualConsistencyStrategy.AcceptanceDecision.ACCEPT) {
                q.insert((SetAbsentEntry<K>)absentEntry);
                entry = q.entry();
                if (!1.$assertionsDisabled && entry == null) {
                    throw new AssertionError();
                }
                entry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
                if (q.remoteIdentifier() == q.currentNodeIdentifier()) {
                    entry.raiseChanged();
                } else {
                    entry.dropChanged();
                }
            } else if (((ReplicableEntry)((Object)absentEntry)).originIdentifier() == q.remoteIdentifier() && q.remoteIdentifier() != q.currentNodeIdentifier()) {
                ((ReplicableEntry)((Object)absentEntry)).raiseChangedFor(q.remoteIdentifier());
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

