/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import org.jetbrains.annotations.NotNull;

public final class StopBitSizeMarshaller
implements SizeMarshaller,
EnumMarshallable<StopBitSizeMarshaller> {
    public static final StopBitSizeMarshaller INSTANCE = new StopBitSizeMarshaller();
    private static final long MIN_ENCODABLE_SIZE = Long.MIN_VALUE;
    private static final long MAX_ENCODABLE_SIZE = Long.MAX_VALUE;

    private StopBitSizeMarshaller() {
    }

    private static void rangeChecks(long minSize, long maxSize) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException("minSize = " + minSize + ", maxSize = " + maxSize);
        }
    }

    @Override
    public int storingLength(long size) {
        return BytesUtil.stopBitLength((long)size);
    }

    @Override
    public long minStorableSize() {
        return Long.MIN_VALUE;
    }

    @Override
    public long maxStorableSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int minStoringLengthOfSizesInRange(long minSize, long maxSize) {
        StopBitSizeMarshaller.rangeChecks(minSize, maxSize);
        if (minSize * maxSize < 0L) {
            return 1;
        }
        return Math.min(this.storingLength(minSize), this.storingLength(maxSize));
    }

    @Override
    public int maxStoringLengthOfSizesInRange(long minSize, long maxSize) {
        StopBitSizeMarshaller.rangeChecks(minSize, maxSize);
        return Math.max(this.storingLength(minSize), this.storingLength(maxSize));
    }

    @Override
    public void writeSize(Bytes<?> out, long sizeToWrite) {
        BytesUtil.writeStopBit(out, (long)sizeToWrite);
    }

    @Override
    public long readSize(Bytes<?> in) {
        return BytesUtil.readStopBit(in);
    }

    @NotNull
    public StopBitSizeMarshaller readResolve() {
        return INSTANCE;
    }
}

