/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.query;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupSearch;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.set.SetEntry;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class HashQuery<K>
implements SetEntry<K> {
    @StageRef
    public VanillaChronicleHashHolder<K> hh;
    final DataAccess<K> innerInputKeyDataAccess;
    @StageRef
    public SegmentStages s;
    @StageRef
    public HashEntryStages<K> entry;
    @StageRef
    public HashLookupSearch hashLookupSearch;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    public HashLookupPos hlp;
    @StageRef
    public KeySearch<K> ks;
    @Stage(value="InputKeyDataAccess")
    private boolean inputKeyDataAccessInitialized;
    @Stage(value="PresenceOfEntry")
    private EntryPresence entryPresence;

    public HashQuery() {
        this.innerInputKeyDataAccess = (DataAccess)this.hh.h().keyDataAccess.copy();
        this.inputKeyDataAccessInitialized = false;
        this.entryPresence = null;
    }

    void initInputKeyDataAccess() {
        this.inputKeyDataAccessInitialized = true;
    }

    void closeInputKeyDataAccess() {
        this.innerInputKeyDataAccess.uninit();
        this.inputKeyDataAccessInitialized = false;
    }

    public DataAccess<K> inputKeyDataAccess() {
        this.initInputKeyDataAccess();
        return this.innerInputKeyDataAccess;
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.s.locksInit() && this.s.nestedContextsLockedOnSameSegment && this.s.rootContextLockedOnThisSegment.latestSameThreadSegmentModCount() != this.s.contextModCount && this.ks.keySearchInit() && this.ks.searchStatePresent() && !this.hashLookupSearch.checkSlotContainsExpectedKeyAndValue(this.entry.pos)) {
            this.hlp.closeHashLookupPos();
        }
    }

    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.ks.inputKey;
    }

    private void initPresenceOfEntry() {
        this.entryPresence = this.ks.searchStatePresent() || this.tieredEntryPresent() ? EntryPresence.PRESENT : EntryPresence.ABSENT;
    }

    public void initPresenceOfEntry(EntryPresence entryPresence) {
        this.entryPresence = entryPresence;
    }

    private boolean tieredEntryPresent() {
        int firstTier;
        block5: {
            firstTier = this.s.tier;
            long firstTierBaseAddr = this.s.tierBaseAddr;
            do {
                if (this.s.hasNextTier()) {
                    this.s.nextTier();
                } else if (this.s.tier != 0) {
                    this.s.initSegmentTier();
                }
                if (this.s.tierBaseAddr == firstTierBaseAddr) break block5;
            } while (!this.ks.searchStatePresent());
            return true;
        }
        if (firstTier != 0) {
            this.s.initSegmentTier();
        }
        return false;
    }

    public boolean entryPresent() {
        return this.entryPresence == EntryPresence.PRESENT;
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerWriteLock.lock();
        if (!this.ks.searchStatePresent()) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": Entry is absent when doRemove() is called");
        }
        this.entry.innerRemoveEntryExceptHashLookupUpdate();
        this.hashLookupSearch.remove();
        this.ks.setSearchState(KeySearch.SearchState.ABSENT);
        this.initPresenceOfEntry(EntryPresence.ABSENT);
    }

    public static enum EntryPresence {
        PRESENT,
        ABSENT;

    }
}

