/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class UpdateLock
implements InterProcessLock {
    @StageRef
    VanillaChronicleHashHolder<?> hh;
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    SegmentStages s;
    @StageRef
    HashEntryStages<?> entry;

    @Override
    public boolean isHeldByCurrentThread() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        return this.s.localLockState.update;
    }

    @Override
    public void lock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    try {
                        this.s.segmentHeader.updateLock(this.s.segmentHeaderAddress);
                    }
                    catch (InterProcessDeadLockException e) {
                        throw this.s.debugContextsAndLocks(e);
                    }
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
        }
    }

    @NotNull
    private IllegalMonitorStateException forbiddenUpgrade() {
        return new IllegalMonitorStateException(this.hh.h().toIdentityString() + ": Cannot upgrade from read to update lock");
    }

    @NotNull
    private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
        return new IllegalStateException(this.hh.h().toIdentityString() + ": Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    try {
                        this.s.segmentHeader.updateLockInterruptibly(this.s.segmentHeaderAddress);
                    }
                    catch (InterProcessDeadLockException e) {
                        throw this.s.debugContextsAndLocks(e);
                    }
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
        }
    }

    @Override
    public boolean tryLock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryUpdateLock(this.s.segmentHeaderAddress)) {
                        this.s.incrementUpdate();
                        this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: 
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new IllegalStateException(this.hh.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)this.s.localLockState));
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.updateZero() && this.s.writeZero()) {
                    if (!this.s.readZero()) {
                        throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryUpdateLock(this.s.segmentHeaderAddress, time, unit)) {
                        this.s.incrementUpdate();
                        this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: 
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new IllegalStateException(this.hh.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)this.s.localLockState));
    }

    @Override
    public void unlock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        switch (this.s.localLockState) {
            case UNLOCKED: 
            case READ_LOCKED: {
                return;
            }
            case UPDATE_LOCKED: {
                this.entry.closeDelayedUpdateChecksum();
                if (this.s.decrementUpdate() != 0 || !this.s.writeZero()) break;
                this.s.segmentHeader.downgradeUpdateToReadLock(this.s.segmentHeaderAddress);
                break;
            }
            case WRITE_LOCKED: {
                this.entry.closeDelayedUpdateChecksum();
                if (this.s.decrementWrite() != 0) break;
                if (!this.s.updateZero()) {
                    this.s.segmentHeader.downgradeWriteToUpdateLock(this.s.segmentHeaderAddress);
                    break;
                }
                this.s.segmentHeader.downgradeWriteToReadLock(this.s.segmentHeaderAddress);
            }
        }
        this.s.incrementRead();
        this.s.setLocalLockState(LocalLockState.READ_LOCKED);
    }

    @Override
    public boolean isHeld() {
        return this.s.localLockState != null && this.s.localLockState != LocalLockState.UNLOCKED;
    }
}

