/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;

public final class IntCompactOffHeapLinearHashTable
extends CompactOffHeapLinearHashTable {
    private static final long SCALE = 4L;

    IntCompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        super(h);
    }

    @Override
    long indexToPos(long index) {
        return index * 4L;
    }

    @Override
    public long step(long pos) {
        return pos + 4L & this.capacityMask2;
    }

    @Override
    public long stepBack(long pos) {
        return pos - 4L & this.capacityMask2;
    }

    @Override
    public long readEntry(long address, long pos) {
        return OS.memory().readInt(address + pos);
    }

    @Override
    public long readEntryVolatile(long address, long pos) {
        return OS.memory().readVolatileInt(address + pos);
    }

    @Override
    public void writeEntryVolatile(long address, long pos, long key, long value) {
        OS.memory().writeVolatileInt(address + pos, (int)this.entry(key, value));
    }

    @Override
    public void writeEntry(long address, long pos, long newEntry) {
        OS.memory().writeInt(address + pos, (int)newEntry);
    }

    @Override
    public void clearEntry(long address, long pos) {
        OS.memory().writeInt(address + pos, 0);
    }
}

