/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.jetbrains.annotations.NotNull;

public interface ChronicleMap<K, V>
extends ConcurrentMap<K, V>,
ChronicleHash<K, MapEntry<K, V>, MapSegmentContext<K, V, ?>, ExternalMapQueryContext<K, V, ?>> {
    public static <K, V> ChronicleMapBuilder<K, V> of(Class<K> keyClass, Class<V> valueClass) {
        return ChronicleMapBuilder.of(keyClass, valueClass);
    }

    @Override
    public V get(Object var1);

    public V getUsing(K var1, V var2);

    public V acquireUsing(@NotNull K var1, V var2);

    @NotNull
    public Closeable acquireContext(@NotNull K var1, @NotNull V var2);

    public <R> R getMapped(K var1, @NotNull SerializableFunction<? super V, R> var2);

    public void getAll(File var1) throws IOException;

    public void putAll(File var1) throws IOException;

    public Class<V> valueClass();

    public Type valueType();

    default public short percentageFreeSpace() {
        throw new UnsupportedOperationException("todo");
    }

    default public SegmentStats[] segmentStats() {
        throw new UnsupportedOperationException("todo");
    }

    default public int remainingAutoResizes() {
        throw new UnsupportedOperationException("todo");
    }

    default public double maxBloatFactor() {
        throw new UnsupportedOperationException("todo");
    }

    public static class SegmentStats
    extends SelfDescribingMarshallable {
        long usedBytes;
        long sizeInBytes;
        int tiers;

        public int tiers() {
            return this.tiers;
        }

        public long usedBytes() {
            return this.usedBytes;
        }

        public long sizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

