/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleMarshaller
implements SizedReader<Double>,
BytesReader<Double>,
SizedWriter<Double>,
BytesWriter<Double>,
EnumMarshallable<DoubleMarshaller> {
    public static final DoubleMarshaller INSTANCE = new DoubleMarshaller();

    private DoubleMarshaller() {
    }

    @Override
    @NotNull
    public Double read(@NotNull Bytes in, long size, @Nullable Double using) {
        return in.readDouble();
    }

    @Override
    public long size(@NotNull Double toWrite) {
        return 8L;
    }

    @Override
    public void write(@NotNull Bytes out, long size, @NotNull Double toWrite) {
        out.writeDouble(toWrite.doubleValue());
    }

    @Override
    @NotNull
    public Double read(Bytes in, @Nullable Double using) {
        return in.readDouble();
    }

    @Override
    public void write(Bytes out, @NotNull Double toWrite) {
        out.writeDouble(toWrite.doubleValue());
    }

    @NotNull
    public DoubleMarshaller readResolve() {
        return INSTANCE;
    }
}

