/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class FileIOUtils {
    private FileIOUtils() {
    }

    public static void readFully(FileChannel fileChannel, long filePosition, ByteBuffer buffer) throws IOException {
        int bytesRead;
        int startBufferPosition = buffer.position();
        while (buffer.remaining() > 0 && (long)buffer.position() < fileChannel.size() && (bytesRead = fileChannel.read(buffer, filePosition + (long)buffer.position() - (long)startBufferPosition)) != -1) {
        }
    }

    public static void writeFully(FileChannel fileChannel, long filePosition, ByteBuffer buffer) throws IOException {
        int startBufferPosition = buffer.position();
        while (buffer.remaining() > 0) {
            fileChannel.write(buffer, filePosition + (long)buffer.position() - (long)startBufferPosition);
        }
    }
}

