/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OldDeletedEntriesCleanupThread
extends Thread
implements Closeable,
Predicate<ReplicableEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(OldDeletedEntriesCleanupThread.class);
    private final WeakReference<ReplicatedChronicleMap<?, ?, ?>> mapRef;
    private final long cleanupTimeout;
    private final TimeUnit cleanupTimeoutUnit;
    private final int segments;
    private final int[] segmentsPermutation;
    private final int[] inverseSegmentsPermutation;
    private final Object cleanupSleepingHandle = new Object();
    private volatile boolean shutdown;
    private long prevSegment0ScanStart = -1L;
    private long removedCompletely;

    OldDeletedEntriesCleanupThread(ReplicatedChronicleMap<?, ?, ?> map) {
        super("Cleanup Thread for " + map.toIdentityString());
        this.setDaemon(true);
        this.mapRef = new WeakReference(map);
        this.cleanupTimeout = map.cleanupTimeout;
        this.cleanupTimeoutUnit = map.cleanupTimeoutUnit;
        this.segments = map.segments();
        this.segmentsPermutation = OldDeletedEntriesCleanupThread.randomPermutation(map.segments());
        this.inverseSegmentsPermutation = OldDeletedEntriesCleanupThread.inversePermutation(this.segmentsPermutation);
    }

    private static int[] randomPermutation(int n) {
        int[] a = new int[n];
        for (int i = 0; i < n; ++i) {
            a[i] = i;
        }
        OldDeletedEntriesCleanupThread.shuffle(a);
        return a;
    }

    private static void shuffle(int[] a) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = a.length - 1; i > 0; --i) {
            int index = ((Random)rnd).nextInt(i + 1);
            int e = a[index];
            a[index] = a[i];
            a[i] = e;
        }
    }

    private static int[] inversePermutation(int[] permutation) {
        int n = permutation.length;
        int[] inverse = new int[n];
        for (int i = 0; i < n; ++i) {
            inverse[permutation[i]] = i;
        }
        return inverse;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            int nextSegmentIndex = this.cleanupSegment();
            if (nextSegmentIndex == -1) {
                return;
            }
            if (nextSegmentIndex != 0) continue;
            long currentTime = TimeProvider.currentTime();
            long mapScanTime = TimeProvider.systemTimeIntervalBetween(this.prevSegment0ScanStart, currentTime, this.cleanupTimeoutUnit);
            LOG.debug("Old deleted entries scan time: {} {}", (Object)mapScanTime, (Object)this.cleanupTimeoutUnit);
            if (mapScanTime >= this.cleanupTimeout) continue;
            long timeToSleep = this.cleanupTimeoutUnit.toMillis(this.cleanupTimeout - mapScanTime);
            if (timeToSleep > 0L) {
                this.sleepMillis(timeToSleep);
                continue;
            }
            this.sleepNanos(this.cleanupTimeoutUnit.toNanos(this.cleanupTimeout - mapScanTime));
        }
    }

    private int cleanupSegment() {
        ReplicatedChronicleMap map = (ReplicatedChronicleMap)this.mapRef.get();
        if (map == null) {
            return -1;
        }
        int segmentIndex = map.globalMutableState().getCurrentCleanupSegmentIndex();
        try (HashSegmentContext context = map.segmentContext(segmentIndex);){
            if (segmentIndex == 0) {
                this.prevSegment0ScanStart = TimeProvider.currentTime();
            }
            this.removedCompletely = 0L;
            if (((ReplicatedHashSegmentContext)context).forEachSegmentReplicableEntryWhile(this)) {
                LOG.debug("Removed {} old deleted entries in the segment {}", (Object)this.removedCompletely, (Object)segmentIndex);
                int nextSegmentIndex = this.nextSegmentIndex(segmentIndex);
                map.globalMutableState().setCurrentCleanupSegmentIndex(nextSegmentIndex);
                int n = nextSegmentIndex;
                return n;
            }
            assert (this.shutdown);
            int n = -1;
            return n;
        }
    }

    @Override
    public boolean test(ReplicableEntry e) {
        long deleteTimeout;
        if (this.shutdown) {
            return false;
        }
        if (e instanceof MapAbsentEntry && (deleteTimeout = TimeProvider.systemTimeIntervalBetween(e.originTimestamp(), TimeProvider.currentTime(), this.cleanupTimeoutUnit)) > this.cleanupTimeout && !e.isChanged()) {
            e.doRemoveCompletely();
            ++this.removedCompletely;
        }
        return true;
    }

    private void sleepMillis(long millis) {
        long deadline = System.currentTimeMillis() + millis;
        while (System.currentTimeMillis() < deadline && !this.shutdown) {
            LockSupport.parkUntil(this.cleanupSleepingHandle, deadline);
        }
    }

    private void sleepNanos(long nanos) {
        long deadline = System.nanoTime() + nanos;
        while (System.nanoTime() < deadline && !this.shutdown) {
            LockSupport.parkNanos(this.cleanupSleepingHandle, deadline);
        }
    }

    public void close() {
        this.shutdown = true;
        if (LockSupport.getBlocker(this) == this.cleanupSleepingHandle) {
            this.interrupt();
        }
    }

    private int nextSegmentIndex(int segmentIndex) {
        int permutationIndex = this.inverseSegmentsPermutation[segmentIndex];
        int nextPermutationIndex = (permutationIndex + 1) % this.segments;
        return this.segmentsPermutation[nextPermutationIndex];
    }
}

