/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util.math;

import net.openhft.chronicle.hash.impl.util.math.Gamma;

public class PoissonDistribution {
    private static final double EPSILON = 1.0E-12;
    private static final long UPPER_BOUND = 0x1000000000L;
    private static final int MAX_ITERATIONS = 10000000;

    public static double cumulativeProbability(double mean, long x) {
        if (x < 0L) {
            return 0.0;
        }
        if (x >= 0x1000000000L) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)x + 1.0, mean, 1.0E-12, 10000000);
    }

    public static long inverseCumulativeProbability(double mean, double p) {
        boolean chebyshevApplies;
        PoissonDistribution.checkProbability(p);
        long lower = 0L;
        if (p == 0.0) {
            return lower;
        }
        --lower;
        long upper = 0x1000000000L;
        if (p == 1.0) {
            return upper;
        }
        double mu = mean;
        double variance = mean;
        double sigma = Math.sqrt(variance);
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sigma) && !Double.isNaN(sigma) && sigma != 0.0;
        if (chebyshevApplies) {
            double k = Math.sqrt((1.0 - p) / p);
            double tmp = mu - k * sigma;
            if (tmp > (double)lower) {
                lower = (int)Math.ceil(tmp) - 1;
            }
            if ((tmp = mu + (k = 1.0 / k) * sigma) < (double)upper) {
                upper = (int)Math.ceil(tmp) - 1;
            }
        }
        return PoissonDistribution.solveInverseCumulativeProbability(mean, p, lower, upper);
    }

    private static void checkProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability should be in [0.0, 1.0] bounds, " + p + " given");
        }
    }

    private static long solveInverseCumulativeProbability(double mean, double p, long lower, long upper) {
        while (lower + 1L < upper) {
            double pm;
            long xm = (lower + upper) / 2L;
            if (xm < lower || xm > upper) {
                xm = lower + (upper - lower) / 2L;
            }
            if ((pm = PoissonDistribution.checkedCumulativeProbability(mean, xm)) >= p) {
                upper = xm;
                continue;
            }
            lower = xm;
        }
        return upper;
    }

    public static double meanByCumulativeProbabilityAndValue(double p, long x, double precision) {
        PoissonDistribution.checkProbability(p);
        assert (x > 0L && x < 0x1000000000L);
        double lower = 0.0;
        double upper = 6.8719476736E10;
        while (lower + precision < upper) {
            double m = (lower + upper) / 2.0;
            double pm = PoissonDistribution.checkedCumulativeProbability(m, x);
            if (pm < p) {
                upper = m;
                continue;
            }
            lower = m;
        }
        return lower;
    }

    private static double checkedCumulativeProbability(double mean, long argument) {
        double result = PoissonDistribution.cumulativeProbability(mean, argument);
        if (Double.isNaN(result)) {
            throw new AssertionError((Object)("Discrete cumulative probability function returned NaN for argument " + argument));
        }
        return result;
    }
}

