/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.tree.ChronicleQueueView;
import net.openhft.chronicle.network.NetworkStats;
import net.openhft.chronicle.network.WireNetworkStats;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkStatsSummary
implements EventHandler {
    private final long index;
    private double alpha = 0.016666666666666666;
    @Nullable
    private final RollingChronicleQueue rollingChronicleQueue;
    @NotNull
    private final MapView<String, Stats> latestStatsPerClientId;
    @NotNull
    private ExcerptTailer tailer = null;
    private final NetworkStats ns = new WireNetworkStats();
    @NotNull
    private Stats stats0 = new Stats();

    public NetworkStatsSummary(@NotNull ChronicleQueueView qv, @NotNull MapView<String, Stats> latestStatsPerClientId) {
        this.rollingChronicleQueue = qv.chronicleQueue();
        this.latestStatsPerClientId = latestStatsPerClientId;
        Collection values = this.latestStatsPerClientId.values();
        AtomicLong index = new AtomicLong();
        values.forEach(v -> index.set(Math.max(index.get(), v.index)));
        this.index = index.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean action() throws InvalidEventHandlerException, InterruptedException {
        try {
            if (this.tailer == null) {
                this.tailer = this.rollingChronicleQueue.createTailer();
                if (this.index > 0L) {
                    this.tailer.moveToIndex(this.index);
                }
                this.tailer.readingDocument(false).close();
            }
            try (DocumentContext documentContext = this.tailer.readingDocument(false);){
                if (!documentContext.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                StringBuilder sb = Wires.acquireStringBuilder();
                ValueIn valueIn = documentContext.wire().read(sb);
                if (!"NetworkStats".contentEquals(sb)) return true;
                valueIn.marshallable((ReadMarshallable)this.ns);
                String userId = this.ns.userId();
                if (userId == null) return true;
                if (userId.isEmpty()) return true;
                this.updateMap(this.ns, documentContext.index());
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }

    private void updateMap(@NotNull NetworkStats ns, long index) {
        String key = ns.userId();
        Stats stats = this.latestStatsPerClientId.getUsing(key, (Object)this.stats0);
        if (stats == null) {
            Stats value = (Stats)((Object)Wires.project(Stats.class, (Object)ns));
            value.writeEma = value.writeBps();
            value.readEma = value.readBps();
            value.index = index;
            this.latestStatsPerClientId.put(key, value);
            return;
        }
        double lastWriteEma = stats.writeEma;
        double lastReadEma = stats.readEma;
        if (this.equalsSecond(stats.timestamp(), ns.timestamp())) {
            long lastWriteBps = stats.writeBps();
            long lastReadBps = stats.readBps();
            Wires.copyTo((Object)ns, (Object)((Object)stats));
            stats.writeBps(stats.writeBps() + lastWriteBps);
            stats.readBps(stats.readBps() + lastReadBps);
        } else {
            Wires.copyTo((Object)ns, (Object)((Object)stats));
        }
        stats.writeEma((double)stats.writeBps() * (1.0 - this.alpha) + lastWriteEma * this.alpha);
        stats.readEma((double)stats.readBps() * (1.0 - this.alpha) + lastReadEma * this.alpha);
        this.latestStatsPerClientId.put(key, stats);
    }

    private boolean equalsSecond(long t1, long t2) {
        return TimeUnit.MILLISECONDS.toSeconds(t1) == TimeUnit.MILLISECONDS.toSeconds(t2);
    }

    public static class Stats
    extends WireNetworkStats {
        double writeEma;
        double readEma;
        long index;

        @NotNull
        Stats writeEma(double writeEma) {
            this.writeEma = writeEma;
            return this;
        }

        @NotNull
        Stats readEma(double readEma) {
            this.readEma = readEma;
            return this;
        }
    }
}

