/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.pubsub.ConsumingSubscriber;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.query.IndexQueueView;
import net.openhft.chronicle.engine.api.query.IndexedValue;
import net.openhft.chronicle.engine.api.query.VanillaIndexQuery;
import net.openhft.chronicle.engine.api.query.VanillaIndexQueueView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.ObjectKVSubscriptionHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutConsumer;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexQueueViewHandler<V extends Marshallable>
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IndexQueueViewHandler.class);
    private final StringBuilder eventName = new StringBuilder();
    private final Map<Long, ConsumingSubscriber<IndexedValue<V>>> tidToListener = new ConcurrentHashMap<Long, ConsumingSubscriber<IndexedValue<V>>>();
    private Asset contextAsset;
    private WireOutPublisher publisher;
    @NotNull
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, inputTid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        try {
            assert (this.startEnforceInValueReadCheck((WireIn)inWire));
            if (EventId.registerSubscriber.contentEquals(this.eventName)) {
                if (this.tidToListener.containsKey(CoreFields.tid)) {
                    this.skipValue(valueIn);
                    LOG.info("Duplicate topic registration for tid " + CoreFields.tid);
                    return;
                }
                ConsumingSubscriber listener = new ConsumingSubscriber<IndexedValue<V>>((Long)inputTid){
                    volatile WireOutConsumer wireOutConsumer;
                    volatile boolean subscriptionEnded;
                    final /* synthetic */ Long val$inputTid;
                    {
                        this.val$inputTid = l;
                    }

                    @Override
                    public void onMessage(@NotNull IndexedValue indexedEntry) throws InvalidSubscriberException {
                        if (IndexQueueViewHandler.this.publisher.isClosed()) {
                            throw new InvalidSubscriberException();
                        }
                        IndexQueueViewHandler.this.publisher.put(indexedEntry.k(), publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                            publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).typedMarshallable((WriteMarshallable)indexedEntry));
                        });
                    }

                    @Override
                    public void onEndOfSubscription() {
                        this.subscriptionEnded = true;
                        if (IndexQueueViewHandler.this.publisher.isClosed()) {
                            return;
                        }
                        IndexQueueViewHandler.this.publisher.put(null, publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                            publish.writeDocument(false, wire -> wire.writeEventName((WireKey)ObjectKVSubscriptionHandler.EventId.onEndOfSubscription).text(""));
                        });
                    }

                    @Override
                    public void addSupplier(@NotNull Supplier<Marshallable> supplier) {
                        IndexQueueViewHandler.this.publisher.addWireConsumer(wireOut -> {
                            Marshallable marshallable = (Marshallable)supplier.get();
                            if (marshallable == null) {
                                return;
                            }
                            if (IndexQueueViewHandler.this.publisher.isClosed()) {
                                return;
                            }
                            wireOut.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                            wireOut.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).typedMarshallable((WriteMarshallable)marshallable));
                        });
                    }

                    public void close() {
                        IndexQueueViewHandler.this.publisher.removeBytesConsumer(this.wireOutConsumer);
                    }
                };
                VanillaIndexQuery query = (VanillaIndexQuery)valueIn.typedMarshallable();
                if (query.select().isEmpty() || query.valueClass() == null) {
                    Jvm.debug().on(this.getClass(), "received empty query");
                    return;
                }
                try {
                    query.filter();
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), "unable to load the filter predicate for this query=" + query, (Throwable)e);
                    assert (this.endEnforceInValueReadCheck((WireIn)inWire));
                    return;
                }
                IndexQueueView indexQueueView = this.contextAsset.acquireView(IndexQueueView.class);
                indexQueueView.registerSubscriber(listener, query);
                return;
            }
            if (EventId.unregisterSubscriber.contentEquals(this.eventName)) {
                this.skipValue(valueIn);
                VanillaIndexQueueView indexQueueView = this.contextAsset.acquireView(VanillaIndexQueueView.class);
                ConsumingSubscriber<IndexedValue<V>> listener = this.tidToListener.remove(inputTid);
                if (listener == null) {
                    Jvm.debug().on(this.getClass(), "No subscriber to present to unsubscribe (" + inputTid + ")");
                    return;
                }
                if (listener instanceof Closeable) {
                    listener.close();
                }
                indexQueueView.unregisterSubscriber(listener);
                return;
            }
        }
        finally {
            assert (this.endEnforceInValueReadCheck((WireIn)inWire));
        }
        this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
    };

    @Override
    protected void unregisterAll() {
        VanillaIndexQueueView indexQueueView = this.contextAsset.acquireView(VanillaIndexQueueView.class);
        this.tidToListener.forEach((k, listener) -> indexQueueView.unregisterSubscriber(listener));
        this.tidToListener.clear();
    }

    void process(@NotNull WireIn inWire, @NotNull RequestContext requestContext, @NotNull Asset contextAsset, @NotNull WireOutPublisher publisher, long tid, @NotNull Wire outWire) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.publisher = publisher;
        this.contextAsset = contextAsset;
        this.requestContext = requestContext;
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        registerSubscriber((WireKey[])new Params[]{Params.subscribe}),
        unregisterSubscriber(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        subscribe;

    }
}

