/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.engine.api.column.ChartProperties;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.VaadinChartSeries;
import net.openhft.chronicle.engine.api.column.VanillaVaadinChart;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.cfg.EngineClusterContext;
import net.openhft.chronicle.engine.fs.Clusters;
import net.openhft.chronicle.engine.fs.EngineCluster;
import net.openhft.chronicle.engine.query.QueueConfig;
import net.openhft.chronicle.engine.server.internal.EngineWireNetworkContext;
import net.openhft.chronicle.engine.server.internal.UberHandler;
import net.openhft.chronicle.engine.tree.ChronicleQueueView;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.network.MarshallableFunction;
import net.openhft.chronicle.network.NetworkStats;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.WireNetworkStats;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.cluster.AbstractSubHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EngineNetworkStatsListener
implements NetworkStatsListener<EngineWireNetworkContext> {
    private static final String PROC_CONNECTIONS_CLUSTER_THROUGHPUT = "/proc/connections/cluster/throughput/";
    private final Asset asset;
    private final int localIdentifier;
    private final WireNetworkStats wireNetworkStats = new WireNetworkStats();
    private QueueView qv;
    private volatile boolean isClosed;
    private EngineWireNetworkContext nc;
    @Nullable
    private Histogram histogram = null;
    private static ThreadLocal<SimpleDateFormat> HH_MM_SS;

    public EngineNetworkStatsListener(Asset asset, int localIdentifier) {
        this.localIdentifier = localIdentifier;
        this.wireNetworkStats.localIdentifier(localIdentifier);
        this.asset = asset;
    }

    private QueueView acquireQV() {
        Asset asset;
        QueueConfig qConfig;
        if (this.qv != null) {
            return this.qv;
        }
        String path = PROC_CONNECTIONS_CLUSTER_THROUGHPUT + this.localIdentifier;
        RequestContext requestContext = RequestContext.requestContext(path).elementType(NetworkStats.class);
        if (ChronicleQueueView.isQueueReplicationAvailable()) {
            requestContext.cluster(this.clusterName());
        }
        if ((qConfig = (asset = this.asset.root().acquireAsset(requestContext.fullName())).getView(QueueConfig.class)) == null) {
            asset.addView(QueueConfig.class, new QueueConfig(s -> this.localIdentifier, false, null, WireType.BINARY));
        }
        this.qv = asset.acquireView(QueueView.class, requestContext);
        return this.qv;
    }

    private String clusterName() {
        Clusters view = this.asset.getView(Clusters.class);
        if (view == null) {
            return "";
        }
        EngineCluster engineCluster = view.firstCluster();
        if (engineCluster == null) {
            return "";
        }
        return engineCluster.clusterName();
    }

    public void networkContext(@NotNull EngineWireNetworkContext nc) {
        this.nc = nc;
    }

    public void onNetworkStats(long writeBps, long readBps, long socketPollCountPerSecond) {
        if (this.isClosed) {
            return;
        }
        this.wireNetworkStats.writeBps(writeBps);
        this.wireNetworkStats.readBps(readBps);
        this.wireNetworkStats.socketPollCountPerSecond(socketPollCountPerSecond);
        this.wireNetworkStats.timestamp(System.currentTimeMillis());
        this.wireNetworkStats.isConnected(!this.nc.isClosed());
        if (this.histogram != null) {
            this.wireNetworkStats.percentile50th((long)((int)(this.histogram.percentile(0.5) / 1000.0)));
            this.wireNetworkStats.percentile90th((long)((int)(this.histogram.percentile(0.9) / 1000.0)));
            this.wireNetworkStats.percentile99th((long)((int)(this.histogram.percentile(0.99) / 1000.0)));
            this.wireNetworkStats.percentile99_9th((long)((int)(this.histogram.percentile(0.999) / 1000.0)));
            this.histogram.reset();
        }
        this.publish();
    }

    private void nc(@NotNull EngineWireNetworkContext nc) {
        this.wireNetworkStats.isAcceptor(nc.isAcceptor());
        if (nc.handler() instanceof AbstractSubHandler) {
            int remoteIdentifier = ((AbstractSubHandler)nc.handler()).remoteIdentifier();
            this.wireNetworkStats.remoteIdentifier(remoteIdentifier);
        } else if (nc.handler() instanceof UberHandler) {
            UberHandler handler = (UberHandler)nc.handler();
            this.wireNetworkStats.remoteIdentifier(handler.remoteIdentifier());
            this.wireNetworkStats.wireType((Enum)handler.wireType());
        } else {
            this.wireNetworkStats.remoteIdentifier(0);
        }
        SessionDetailsProvider sessionDetailsProvider = nc.sessionDetails();
        if (sessionDetailsProvider != null) {
            this.wireNetworkStats.clientId(sessionDetailsProvider.clientId());
            this.wireNetworkStats.userId(sessionDetailsProvider.userId());
            this.wireNetworkStats.wireType((Enum)sessionDetailsProvider.wireType());
        }
    }

    public void onHostPort(@NotNull String hostName, int port) {
        this.wireNetworkStats.remoteHostName(hostName);
        this.wireNetworkStats.remotePort(port);
        this.wireNetworkStats.timestamp(System.currentTimeMillis());
        if (this.isClosed) {
            return;
        }
        this.publish();
    }

    public void onRoundTripLatency(long nanosecondLatency) {
        this.acquireHistogram().sampleNanos(nanosecondLatency);
    }

    @Nullable
    private Histogram acquireHistogram() {
        if (this.histogram != null) {
            return this.histogram;
        }
        this.histogram = new Histogram();
        this.createVaadinChart();
        return this.histogram;
    }

    private void createVaadinChart() {
        String csp = "/proc/connections/cluster/throughput/replication-latency/" + this.localIdentifier + "<->" + this.wireNetworkStats.remoteIdentifier();
        VanillaVaadinChart barChart = (VanillaVaadinChart)this.asset.acquireView(RequestContext.requestContext(csp).view("Chart"));
        barChart.columnNameField("timestamp");
        VaadinChartSeries percentile50th = new VaadinChartSeries("percentile50th").type(VaadinChartSeries.Type.SPLINE).yAxisLabel("microseconds");
        VaadinChartSeries percentile90th = new VaadinChartSeries("percentile90th").type(VaadinChartSeries.Type.SPLINE).yAxisLabel("microseconds");
        VaadinChartSeries percentile99th = new VaadinChartSeries("percentile99th").type(VaadinChartSeries.Type.SPLINE).yAxisLabel("microseconds");
        VaadinChartSeries percentile99_9th = new VaadinChartSeries("percentile99_9th").type(VaadinChartSeries.Type.SPLINE).yAxisLabel("microseconds");
        barChart.series(percentile50th, percentile90th, percentile99th, percentile99_9th);
        ChartProperties chartProperties = new ChartProperties();
        chartProperties.title = "Round Trip Network Latency Distribution";
        chartProperties.menuLabel = "round trip latency";
        chartProperties.countFromEnd = 30L;
        chartProperties.xAxisLabelRender = HourMinSecRenderer.INSTANCE;
        barChart.chartProperties(chartProperties);
        barChart.dataSource(this.qv);
        chartProperties.filter = new ColumnViewInternal.MarshableFilter("percentile99_9th", ">0");
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.wireNetworkStats.writeBps(0L);
        this.wireNetworkStats.readBps(0L);
        this.wireNetworkStats.socketPollCountPerSecond(0L);
        this.wireNetworkStats.timestamp(System.currentTimeMillis());
        this.wireNetworkStats.isConnected(false);
        this.publish();
    }

    private void publish() {
        this.nc(this.nc);
        this.acquireQV().publishAndIndex("", this.wireNetworkStats);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    static {
        RequestContext.loadDefaultAliases();
        HH_MM_SS = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm.ss"));
    }

    public static class Factory
    implements MarshallableFunction<ClusterContext, NetworkStatsListener>,
    Demarshallable {
        @UsedViaReflection
        private Factory(@NotNull WireIn wireIn) {
        }

        public Factory() {
        }

        @NotNull
        public NetworkStatsListener apply(@NotNull ClusterContext context) {
            return new EngineNetworkStatsListener(((EngineClusterContext)context).assetRoot(), context.localIdentifier());
        }
    }

    public static enum HourMinSecRenderer implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object timeMs) {
            return ((SimpleDateFormat)HH_MM_SS.get()).format(new Date((Long)timeMs));
        }
    }
}

