/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiConsumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.column.Row;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.CspManager;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnViewIteratorHandler
extends AbstractHandler {
    private final CspManager cspManager;
    private Iterator<Row> iterator;
    private long cid;
    private final StringBuilder eventName = new StringBuilder();
    private long tid;
    @Nullable
    private WireIn inWire = null;
    @Nullable
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn, Long inputTid) {
            block6: {
                ColumnViewIteratorHandler.this.eventName.setLength(0);
                ValueIn valueIn = ColumnViewIteratorHandler.this.inWire.readEventName(ColumnViewIteratorHandler.this.eventName);
                try {
                    assert (ColumnViewIteratorHandler.this.startEnforceInValueReadCheck(ColumnViewIteratorHandler.this.inWire));
                    ColumnViewIteratorHandler.this.outWire.writeDocument(true, wire -> ColumnViewIteratorHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(ColumnViewIteratorHandler.this.tid));
                    ColumnViewIteratorHandler.this.writeData(ColumnViewIteratorHandler.this.inWire, out -> {
                        if (EventId.next.contentEquals(ColumnViewIteratorHandler.this.eventName)) {
                            int nextChunkSize = valueIn.int32();
                            ArrayList chunk = new ArrayList();
                            for (int i = 0; i < nextChunkSize && ColumnViewIteratorHandler.this.iterator.hasNext(); ++i) {
                                chunk.add(ColumnViewIteratorHandler.this.iterator.next());
                            }
                            ColumnViewIteratorHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).object(chunk);
                            return;
                        }
                        if (EventId.close.contentEquals(ColumnViewIteratorHandler.this.eventName)) {
                            ColumnViewIteratorHandler.this.skipValue(valueIn);
                            ColumnViewIteratorHandler.this.cspManager.removeCid(ColumnViewIteratorHandler.this.cid);
                            return;
                        }
                        throw new IllegalStateException("unsupported event=" + ColumnViewIteratorHandler.this.eventName);
                    });
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), (Throwable)e);
                }
                finally {
                    if ($assertionsDisabled || ColumnViewIteratorHandler.this.endEnforceInValueReadCheck(ColumnViewIteratorHandler.this.inWire)) break block6;
                    throw new AssertionError();
                }
            }
        }
    };

    ColumnViewIteratorHandler(CspManager cspManager) {
        this.cspManager = cspManager;
    }

    public void process(WireIn in, @NotNull WireOut out, long tid, Iterator<Row> iterator, long cid) {
        this.setOutWire(out);
        try {
            this.inWire = in;
            this.outWire = out;
            this.iterator = iterator;
            this.tid = tid;
            this.cid = cid;
            this.dataConsumer.accept(in, tid);
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "", (Throwable)e);
        }
    }

    public static enum EventId implements ParameterizeWireKey
    {
        next(new WireKey[0]),
        close(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

