/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.column.ClosableIterator;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.RemoteColumnView;
import net.openhft.chronicle.engine.api.column.Row;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.CspManager;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ColumnViewHandler
extends AbstractHandler {
    private final CspManager cspManager;
    @NotNull
    AtomicLong nextToken = new AtomicLong();
    private final StringBuilder eventName = new StringBuilder();
    private ColumnViewInternal columnView;
    @Nullable
    private WireIn inWire = null;
    @Nullable
    private Map<String, Object> oldRow = new HashMap<String, Object>();
    @NotNull
    private Map<String, Object> newRow = new HashMap<String, Object>();
    private long tid;
    @NotNull
    private List<ColumnViewInternal.MarshableFilter> filtersList = new ArrayList<ColumnViewInternal.MarshableFilter>();
    @NotNull
    private List<ColumnViewInternal.MarshableFilter> keysList = new ArrayList<ColumnViewInternal.MarshableFilter>();
    @NotNull
    private ColumnViewInternal.SortedFilter sortedFilter = new ColumnViewInternal.SortedFilter();
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn, Long inputTid) {
            block6: {
                ColumnViewHandler.this.eventName.setLength(0);
                ValueIn valueIn = ColumnViewHandler.this.inWire.readEventName(ColumnViewHandler.this.eventName);
                try {
                    assert (ColumnViewHandler.this.startEnforceInValueReadCheck(ColumnViewHandler.this.inWire));
                    ColumnViewHandler.this.outWire.writeDocument(true, wire -> ColumnViewHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(ColumnViewHandler.this.tid));
                    ColumnViewHandler.this.writeData(ColumnViewHandler.this.inWire, out -> {
                        if (RemoteColumnView.EventId.columns.contentEquals(ColumnViewHandler.this.eventName)) {
                            ColumnViewHandler.this.skipValue(valueIn);
                            ColumnViewHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).object(ColumnViewHandler.this.columnView.columns());
                            return;
                        }
                        if (RemoteColumnView.EventId.rowCount.contentEquals(ColumnViewHandler.this.eventName)) {
                            ColumnViewInternal.SortedFilter filters = (ColumnViewInternal.SortedFilter)((Object)((Object)valueIn.object(ColumnViewInternal.SortedFilter.class)));
                            int count = ColumnViewHandler.this.columnView.rowCount(filters == null ? new ColumnViewInternal.SortedFilter() : filters);
                            ColumnViewHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int32(count);
                            return;
                        }
                        if (RemoteColumnView.EventId.changedRow.contentEquals(ColumnViewHandler.this.eventName)) {
                            valueIn.marshallable(wire -> {
                                ColumnViewHandler.this.newRow.clear();
                                ColumnViewHandler.this.oldRow.clear();
                                wire.read(RemoteColumnView.EventId.changedRow.params()[0]).object((Object)ColumnViewHandler.this.newRow, Map.class);
                                wire.read(RemoteColumnView.EventId.changedRow.params()[1]).object((Object)ColumnViewHandler.this.oldRow, Map.class);
                                int result = ColumnViewHandler.this.columnView.changedRow(ColumnViewHandler.this.newRow, ColumnViewHandler.this.oldRow);
                                ColumnViewHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).int32(result);
                            });
                            return;
                        }
                        if (RemoteColumnView.EventId.canDeleteRows.contentEquals(ColumnViewHandler.this.eventName)) {
                            ColumnViewHandler.this.skipValue(valueIn);
                            ColumnViewHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(ColumnViewHandler.this.columnView.canDeleteRows()));
                            return;
                        }
                        if (RemoteColumnView.EventId.containsRowWithKey.contentEquals(ColumnViewHandler.this.eventName)) {
                            ColumnViewHandler.this.keysList.clear();
                            List keys = (List)valueIn.object((Object)ColumnViewHandler.this.keysList, List.class);
                            boolean result = ColumnViewHandler.this.columnView.containsRowWithKey(keys);
                            ColumnViewHandler.this.outWire.writeEventName((WireKey)CoreFields.reply).bool(Boolean.valueOf(result));
                            return;
                        }
                        if (RemoteColumnView.EventId.iterator.contentEquals(ColumnViewHandler.this.eventName)) {
                            valueIn.marshallable((ReadMarshallable)ColumnViewHandler.this.sortedFilter);
                            long token = ColumnViewHandler.this.nextToken.incrementAndGet();
                            long cid = ColumnViewHandler.this.cspManager.createProxy("ColumnViewIterator", token);
                            ClosableIterator<? extends Row> iterator = ColumnViewHandler.this.columnView.iterator(ColumnViewHandler.this.sortedFilter);
                            ColumnViewHandler.this.cspManager.storeObject(cid, iterator);
                            return;
                        }
                        throw new IllegalStateException("unsupported event=" + ColumnViewHandler.this.eventName);
                    });
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), (Throwable)e);
                }
                finally {
                    if ($assertionsDisabled || ColumnViewHandler.this.endEnforceInValueReadCheck(ColumnViewHandler.this.inWire)) break block6;
                    throw new AssertionError();
                }
            }
        }
    };

    ColumnViewHandler(CspManager cspManager) {
        this.cspManager = cspManager;
    }

    public void process(WireIn in, @NotNull WireOut out, ColumnViewInternal view, long tid) {
        this.setOutWire(out);
        try {
            this.inWire = in;
            this.outWire = out;
            this.columnView = view;
            this.tid = tid;
            this.dataConsumer.accept(in, tid);
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "", (Throwable)e);
        }
    }
}

