/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReference<E>
implements Reference<E> {
    private final String name;
    private final Class<E> eClass;
    private final MapView<String, E> underlyingMap;
    @NotNull
    private final Asset asset;

    public MapReference(@NotNull RequestContext context, @NotNull Asset asset, MapView<String, E> underlying) throws AssetNotFoundException {
        this(context.name(), context.type(), asset, underlying);
    }

    public MapReference(String name, Class<E> type, @NotNull Asset asset, MapView<String, E> mapView) {
        assert (asset != null);
        this.name = name;
        this.eClass = type;
        this.asset = asset;
        this.underlyingMap = mapView;
        assert (this.underlyingMap != null);
    }

    @Override
    public long set(E event) {
        this.underlyingMap.set(this.name, event);
        return 0L;
    }

    @Override
    @Nullable
    public E get() {
        return (E)this.underlyingMap.get((Object)this.name);
    }

    @Override
    public void remove() {
        this.underlyingMap.remove(this.name);
    }

    @Override
    public void registerSubscriber(boolean bootstrap, int throttlePeriodMs, @NotNull Subscriber<E> subscriber) throws AssetNotFoundException {
        this.asset.subscription(true).registerSubscriber(RequestContext.requestContext().bootstrap(bootstrap).throttlePeriodMs(throttlePeriodMs).type(this.eClass), subscriber, Filter.empty());
    }

    @Override
    public void unregisterSubscriber(@NotNull Subscriber subscriber) {
        SubscriptionCollection subscription = this.asset.subscription(false);
        if (subscription != null) {
            subscription.unregisterSubscriber(subscriber);
        }
    }

    @Override
    public int subscriberCount() {
        SubscriptionCollection subscription = this.asset.subscription(false);
        if (subscription != null) {
            return subscription.subscriberCount();
        }
        return 0;
    }

    @Override
    public Class getType() {
        return this.eClass;
    }

    @NotNull
    public String toString() {
        return "MapReference{name='" + this.name + '\'' + ", eClass=" + this.eClass + '}';
    }
}

