/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.core.util.SerializableUpdaterWithArg;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.collection.ClientWiredStatelessChronicleCollection;
import net.openhft.chronicle.engine.collection.ClientWiredStatelessChronicleSet;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.server.internal.MapWireHandler;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteKeyValueStore<K, V>
extends AbstractStatelessClient<MapWireHandler.EventId>
implements Cloneable,
ObjectKeyValueStore<K, V> {
    private static final WriteValue VOID_PARAMETERS = WriteMarshallable.EMPTY;
    private final Class<K> kClass;
    private final Class<V> vClass;
    private final Map<Long, String> cidToCsp = new HashMap<Long, String>();
    @NotNull
    private final RequestContext context;
    @NotNull
    private final Asset asset;
    @NotNull
    private final ObjectSubscription<K, V> subscriptions;

    public RemoteKeyValueStore(@NotNull RequestContext context, @NotNull Asset asset, @NotNull TcpChannelHub hub) {
        super(hub, 0L, RemoteKeyValueStore.toUri(context));
        this.asset = asset;
        this.kClass = context.keyType();
        this.vClass = context.valueType();
        this.context = context;
        this.subscriptions = asset.acquireView(ObjectSubscription.class, context);
        this.subscriptions.setKvStore(this);
    }

    public RemoteKeyValueStore(@NotNull RequestContext requestContext, @NotNull Asset asset) {
        this(requestContext, asset, asset.findView(TcpChannelHub.class));
    }

    @NotNull
    private static String toUri(@NotNull RequestContext context) {
        return context.viewType(MapView.class).toUri();
    }

    @Override
    public boolean isKeyType(Object key) {
        return this.kClass.isInstance(key);
    }

    @NotNull
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.putIfAbsent, null, this.vClass, new Object[]{key, value});
    }

    @Override
    public boolean containsValue(V value) {
        throw new UnsupportedOperationException("todo");
    }

    private void checkValue(@Nullable Object value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
    }

    public boolean remove(@Nullable Object key, Object value) {
        if (key == null) {
            return false;
        }
        this.checkValue(value);
        return this.proxyReturnBooleanWithArgs(MapWireHandler.EventId.removeWithValue, new Object[]{key, value});
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        return this.proxyReturnBooleanWithArgs(MapWireHandler.EventId.replaceForOld, new Object[]{key, oldValue, newValue});
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.replace, null, this.vClass, new Object[]{key, value});
    }

    @Nullable
    public <A, R> R applyTo(@NotNull SerializableBiFunction<MapView<K, V>, A, R> function, A arg) {
        return (R)this.proxyReturnTypedObject(MapWireHandler.EventId.applyTo2, null, Object.class, new Object[]{function, arg});
    }

    @Nullable
    public <R, UA, RA> R syncUpdate(SerializableUpdaterWithArg updateFunction, UA ua, SerializableBiFunction returnFunction, RA ra) {
        return (R)this.proxyReturnTypedObject(MapWireHandler.EventId.update4, null, Object.class, new Object[]{updateFunction, ua, returnFunction, ra});
    }

    public <A> void asyncUpdate(SerializableUpdaterWithArg updateFunction, A arg) {
        this.sendEventAsync((WireKey)MapWireHandler.EventId.update2, RemoteKeyValueStore.toParameters((ParameterizeWireKey)MapWireHandler.EventId.update2, (Object[])new Object[]{updateFunction, arg}), true);
    }

    @Override
    public void keysFor(int segment, @NotNull SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        this.keySet().forEach(ThrowingConsumer.asConsumer(kConsumer::accept));
    }

    @Override
    public void entriesFor(int segment, @NotNull SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        String assetName = this.asset.fullName();
        this.entrySet().forEach(ThrowingConsumer.asConsumer(entry -> kvConsumer.accept(InsertedEvent.of(assetName, entry.getKey(), entry.getValue(), false))));
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass().isAssignableFrom(Map.class)) {
            return false;
        }
        Map that = (Map)object;
        if ((long)that.size() != this.longSize()) {
            return false;
        }
        Set<Map.Entry<K, V>> entries = this.entrySet();
        return that.entrySet().equals(entries);
    }

    public int hashCode() {
        return this.proxyReturnInt(MapWireHandler.EventId.hashCode);
    }

    @NotNull
    public String toString() {
        if (Jvm.isDebug()) {
            return "toString() not available while debugging";
        }
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        if (!entries.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (entries.hasNext()) {
            Map.Entry<K, V> e = entries.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!entries.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.longSize() == 0L;
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.proxyReturnBoolean(MapWireHandler.EventId.containsKey, out -> out.object(key));
    }

    @Override
    @Nullable
    public V get(Object key) {
        this.checkKey(key);
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.get, null, this.vClass, new Object[]{key});
    }

    @Override
    @Nullable
    public V getUsing(K key, Object usingValue) {
        this.checkKey(key);
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.get, usingValue, this.vClass, new Object[]{key});
    }

    @Override
    public long longSize() {
        return this.proxyReturnLong((WireKey)MapWireHandler.EventId.size);
    }

    @Override
    public boolean remove(Object key) {
        this.checkKey(key);
        this.sendEventAsync((WireKey)MapWireHandler.EventId.remove, RemoteKeyValueStore.toParameters((ParameterizeWireKey)MapWireHandler.EventId.remove, (Object[])new Object[]{key}), true);
        return false;
    }

    @Override
    @Nullable
    public V getAndRemove(Object key) {
        this.checkKey(key);
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.getAndRemove, null, this.vClass, new Object[]{key});
    }

    private void checkKey(@Nullable Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
    }

    @Override
    public boolean put(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        this.sendEventAsync((WireKey)MapWireHandler.EventId.put, RemoteKeyValueStore.toParameters((ParameterizeWireKey)MapWireHandler.EventId.put, (Object[])new Object[]{key, value}), true);
        return false;
    }

    @Override
    @Nullable
    public V getAndPut(Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        return (V)this.proxyReturnTypedObject(MapWireHandler.EventId.getAndPut, null, this.vClass, new Object[]{key, value});
    }

    @Override
    public void clear() {
        this.proxyReturnVoid((WireKey)MapWireHandler.EventId.clear);
    }

    @Nullable
    public Collection<V> values() {
        StringBuilder csp = Wires.acquireStringBuilder();
        long cid = (Long)this.proxyReturnWireConsumer((WireKey)MapWireHandler.EventId.values, read -> {
            read.typePrefix();
            return (Long)read.applyToMarshallable(w -> {
                CoreFields.stringEvent((WireKey)CoreFields.csp, (StringBuilder)csp, (WireIn)w);
                long cid0 = CoreFields.cid((WireIn)w);
                this.cidToCsp.put(cid0, csp.toString());
                return cid0;
            });
        });
        Function<ValueIn, Object> consumer = valueIn -> valueIn.object(this.vClass);
        return new ClientWiredStatelessChronicleCollection<Object, ArrayList>(this.hub, ArrayList::new, consumer, "/" + this.context.name() + "?view=values", cid);
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        StringBuilder csp = Wires.acquireStringBuilder();
        long cid = (Long)this.proxyReturnWireConsumer((WireKey)MapWireHandler.EventId.entrySet, read -> {
            read.typePrefix();
            return (Long)read.applyToMarshallable(w -> {
                CoreFields.stringEvent((WireKey)CoreFields.csp, (StringBuilder)csp, (WireIn)w);
                long cid0 = CoreFields.cid((WireIn)w);
                this.cidToCsp.put(cid0, csp.toString());
                return cid0;
            });
        });
        Function<ValueIn, Map.Entry> consumer = valueIn -> valueIn.applyToMarshallable(r -> {
            final Object k = r.read(() -> "key").object(this.kClass);
            final Object v = r.read(() -> "value").object(this.vClass);
            return new Map.Entry<K, V>(){

                @Override
                @Nullable
                public K getKey() {
                    return k;
                }

                @Override
                @Nullable
                public V getValue() {
                    return v;
                }

                @Override
                @NotNull
                public V setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
        });
        return new ClientWiredStatelessChronicleSet<Map.Entry<K, V>>(this.hub, csp.toString(), cid, consumer);
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        return this.entrySet().iterator();
    }

    @NotNull
    public Set<K> keySet() {
        StringBuilder csp = Wires.acquireStringBuilder();
        long cid = (Long)this.proxyReturnWireConsumer((WireKey)MapWireHandler.EventId.keySet, read -> {
            read.typePrefix();
            return (Long)read.applyToMarshallable(w -> {
                CoreFields.stringEvent((WireKey)CoreFields.csp, (StringBuilder)csp, (WireIn)w);
                long cid0 = CoreFields.cid((WireIn)w);
                this.cidToCsp.put(cid0, csp.toString());
                return cid0;
            });
        });
        return new ClientWiredStatelessChronicleSet<Object>(this.hub, csp.toString(), cid, valueIn -> valueIn.object(this.kClass));
    }

    private boolean proxyReturnBoolean(@NotNull MapWireHandler.EventId eventId, @Nullable WriteValue consumer) {
        long startTime = Time.currentTimeMillis();
        return (Boolean)this.attempt(() -> this.readBoolean(this.sendEvent(startTime, (WireKey)eventId, consumer), startTime));
    }

    private int proxyReturnInt(@NotNull MapWireHandler.EventId eventId) {
        long startTime = Time.currentTimeMillis();
        return (Integer)this.attempt(() -> this.readInt(this.sendEvent(startTime, (WireKey)eventId, VOID_PARAMETERS), startTime));
    }

    @Override
    @NotNull
    public Asset asset() {
        return this.asset;
    }

    @Override
    @NotNull
    public KeyValueStore<K, V> underlying() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ObjectSubscription<K, V> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    public Class<K> keyType() {
        return this.kClass;
    }

    @Override
    public Class<V> valueType() {
        return this.vClass;
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("");
    }

    class Entry
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k1, V v) {
            this.value = v;
            this.key = k1;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            RemoteKeyValueStore.this.put(this.getKey(), newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @NotNull
        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

