/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.AbstractKeyValueStore;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaSubscriptionKeyValueStore<K, MV, V>
extends AbstractKeyValueStore<K, V>
implements ObjectKeyValueStore<K, V>,
AuthenticatedKeyValueStore<K, V> {
    @NotNull
    private final ObjectSubscription<K, V> subscriptions;

    public VanillaSubscriptionKeyValueStore(@NotNull RequestContext context, @NotNull Asset asset, @NotNull KeyValueStore<K, V> item) {
        super(context, asset, item);
        this.subscriptions = asset.acquireView(ObjectSubscription.class, context);
        this.subscriptions.setKvStore(this);
    }

    @Override
    @NotNull
    public ObjectSubscription<K, V> subscription(boolean createIfAbsent) {
        return this.subscriptions;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        V oldValue = this.kvStore.replace(key, value);
        if (oldValue != null) {
            this.subscriptions.notifyEvent(UpdatedEvent.of(this.asset.fullName(), key, oldValue, value, false, !value.equals(oldValue)));
        }
        return oldValue;
    }

    @Override
    public boolean put(@NotNull K key, V value) {
        if (this.subscriptions.needsPrevious()) {
            return this.getAndPut(key, value) != null;
        }
        boolean replaced = this.kvStore.put(key, value);
        this.subscriptions.notifyEvent((MapEvent<K, V>)(replaced ? UpdatedEvent.of(this.asset.fullName(), key, null, value, false, true) : InsertedEvent.of(this.asset.fullName(), key, value, false)));
        return replaced;
    }

    @Override
    public boolean remove(K key) {
        if (this.subscriptions.needsPrevious()) {
            return this.getAndRemove(key) != null;
        }
        if (this.kvStore.remove(key)) {
            this.subscriptions.notifyEvent(RemovedEvent.of(this.asset.fullName(), key, null, false));
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceIfEqual(@NotNull K key, V oldValue, V newValue) {
        if (this.kvStore.replaceIfEqual(key, oldValue, newValue)) {
            this.subscriptions.notifyEvent(UpdatedEvent.of(this.asset.fullName(), key, oldValue, newValue, false, true));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIfEqual(@NotNull K key, V value) {
        if (this.kvStore.removeIfEqual(key, value)) {
            this.subscriptions.notifyEvent(RemovedEvent.of(this.asset.fullName(), key, value, false));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V putIfAbsent(@NotNull K key, V value) {
        V ret = this.kvStore.putIfAbsent(key, value);
        if (ret == null) {
            this.subscriptions.notifyEvent(InsertedEvent.of(this.asset.fullName(), key, value, false));
        }
        return ret;
    }

    @Override
    @Nullable
    public V getAndPut(@NotNull K key, V value) {
        V oldValue = this.kvStore.getAndPut(key, value);
        this.subscriptions.notifyEvent((MapEvent<K, V>)(oldValue == null ? InsertedEvent.of(this.asset.fullName(), key, value, false) : UpdatedEvent.of(this.asset.fullName(), key, oldValue, value, false, !oldValue.equals(value))));
        return oldValue;
    }

    @Override
    @Nullable
    public V getAndRemove(@NotNull K key) {
        Object oldValue = this.kvStore.getAndRemove(key);
        if (oldValue != null) {
            this.subscriptions.notifyEvent(RemovedEvent.of(this.asset.fullName(), key, oldValue, false));
        }
        return oldValue;
    }
}

