/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import net.openhft.chronicle.engine.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaMapView<K, V>
implements MapView<K, V> {
    protected final Class keyClass;
    protected final Class valueType;
    @NotNull
    protected final Asset asset;
    @NotNull
    protected final RequestContext context;
    protected final boolean putReturnsNull;
    protected final boolean removeReturnsNull;
    @NotNull
    private final KeyValueStore<K, V> kvStore;
    private AbstractCollection<V> values;

    public VanillaMapView(@NotNull RequestContext context, @NotNull Asset asset, @NotNull KeyValueStore<K, V> kvStore) {
        this.context = context;
        this.keyClass = context.keyType();
        this.valueType = context.valueType();
        this.asset = asset;
        this.kvStore = kvStore;
        this.putReturnsNull = context.putReturnsNull() != Boolean.FALSE;
        this.removeReturnsNull = context.removeReturnsNull() != Boolean.FALSE;
    }

    @Override
    public Class<K> keyType() {
        return this.keyClass;
    }

    @Override
    public Class<V> valueType() {
        return this.valueType;
    }

    @Override
    @Nullable
    public V getUsing(K key, Object usingValue) {
        return this.kvStore.getUsing(key, usingValue);
    }

    @Override
    @NotNull
    public KeySetView<K> keySet() {
        return this.asset.acquireView(KeySetView.class, this.context);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        @NotNull
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = VanillaMapView.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return VanillaMapView.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return VanillaMapView.this.isEmpty();
                }

                @Override
                public void clear() {
                    VanillaMapView.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return VanillaMapView.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.longSize() == 0L;
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.keyClass.isInstance(key) && this.kvStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkValue(value);
        try {
            for (int i = 0; i < this.kvStore.segments(); ++i) {
                this.kvStore.entriesFor(i, e -> {
                    if (BytesUtil.equals(e.getValue(), (Object)value)) {
                        throw new InvalidSubscriberException();
                    }
                });
            }
            return false;
        }
        catch (InvalidSubscriberException e2) {
            return true;
        }
    }

    protected void checkKey(@Nullable Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
    }

    protected void checkValue(@Nullable Object value) {
        if (value == null) {
            throw new NullPointerException("value can not be null");
        }
    }

    @Override
    @NotNull
    public Asset asset() {
        return this.asset;
    }

    @Override
    public KeyValueStore<K, V> underlying() {
        return this.kvStore;
    }

    @Override
    @Nullable
    public V get(Object key) {
        this.checkKey(key);
        return this.kvStore.isKeyType(key) ? (V)this.kvStore.getUsing(key, null) : null;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        if (this.putReturnsNull) {
            this.kvStore.put(key, value);
            return null;
        }
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    public void set(K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        this.kvStore.put(key, value);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        this.checkKey(key);
        if (!this.kvStore.isKeyType(key)) {
            return null;
        }
        Object key2 = key;
        if (this.removeReturnsNull) {
            this.kvStore.remove(key2);
            return null;
        }
        return this.kvStore.getAndRemove(key2);
    }

    @Override
    public void putAll(@net.openhft.chronicle.core.annotation.NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    @Nullable
    public V getAndPut(K key, V value) {
        return this.kvStore.getAndPut(key, value);
    }

    @Override
    @Nullable
    public V getAndRemove(K key) {
        return this.kvStore.getAndRemove(key);
    }

    @Override
    @NotNull
    public EntrySetView<K, Object, V> entrySet() {
        return this.asset.acquireView(EntrySetView.class);
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    @Nullable
    public V putIfAbsent(@net.openhft.chronicle.core.annotation.NotNull K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(@net.openhft.chronicle.core.annotation.NotNull Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.isKeyType(key) && this.kvStore.removeIfEqual(key, value);
    }

    @Override
    public boolean replace(@net.openhft.chronicle.core.annotation.NotNull K key, @net.openhft.chronicle.core.annotation.NotNull V oldValue, @net.openhft.chronicle.core.annotation.NotNull V newValue) {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        return this.kvStore.replaceIfEqual(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public V replace(@net.openhft.chronicle.core.annotation.NotNull K key, @net.openhft.chronicle.core.annotation.NotNull V value) {
        this.checkKey(key);
        this.checkValue(value);
        return this.kvStore.replace(key, value);
    }

    @Override
    public void registerTopicSubscriber(@NotNull TopicSubscriber<K, V> topicSubscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerTopicSubscriber(RequestContext.requestContext().bootstrap(true).type(this.keyClass).type2(this.valueType), topicSubscriber);
    }

    @Override
    public void registerKeySubscriber(@NotNull Subscriber<K> subscriber) {
        this.registerKeySubscriber(subscriber, Filter.empty(), EnumSet.of(RequestContext.Operation.BOOTSTRAP));
    }

    @Override
    public void registerKeySubscriber(@NotNull Subscriber<K> subscriber, @NotNull Filter filter, @NotNull Set<RequestContext.Operation> operations) {
        RequestContext rc = this.context.clone();
        operations.forEach((? super T e) -> e.apply(rc));
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerKeySubscriber(rc.type(this.keyClass), subscriber, filter);
    }

    @Override
    public void registerSubscriber(@NotNull Subscriber<MapEvent<K, V>> subscriber) {
        this.registerSubscriber(subscriber, Filter.empty(), EnumSet.of(RequestContext.Operation.BOOTSTRAP));
    }

    @Override
    public void registerSubscriber(@NotNull Subscriber<MapEvent<K, V>> subscriber, @NotNull Filter<MapEvent<K, V>> filter, @NotNull Set<RequestContext.Operation> operations) {
        RequestContext rc = this.context.clone();
        rc.bootstrap(true).elementType(MapEvent.class);
        operations.forEach((? super T e) -> e.apply(rc));
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerSubscriber(rc, subscriber, filter);
    }

    @Override
    @NotNull
    public Reference<V> referenceFor(K key) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.kvStore.segments(); ++i) {
                    this.kvStore.entriesFor(i, e -> {
                        if (!BytesUtil.equals(e.getValue(), map.get(e.getKey()))) {
                            throw new InvalidSubscriberException();
                        }
                    });
                }
                return true;
            }
            catch (InvalidSubscriberException e2) {
                return false;
            }
        }
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        try {
            for (int i = 0; i < this.kvStore.segments(); ++i) {
                this.kvStore.entriesFor(i, e -> sb.append(e.getKey()).append("=").append(e.getValue()).append(", "));
            }
            if (sb.length() > 3) {
                sb.setLength(sb.length() - 2);
            }
            return sb.append("}").toString();
        }
        catch (Exception e2) {
            sb.append(e2);
            return sb.toString();
        }
    }
}

