/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.engine.api.column.ClosableIterator;
import net.openhft.chronicle.engine.api.column.Column;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.MapColumnView;
import net.openhft.chronicle.engine.api.column.Row;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapWrappingColumnView<K, V>
implements MapColumnView {
    private final RequestContext requestContext;
    private final Asset asset;
    @NotNull
    private final MapView<K, V> mapView;
    private final boolean valueMarshallable;
    private final boolean valueMap;
    @Nullable
    private ArrayList<String> columnNames = null;

    public MapWrappingColumnView(RequestContext requestContext, Asset asset, @NotNull MapView<K, V> mapView) {
        this.requestContext = requestContext;
        this.asset = asset;
        this.mapView = mapView;
        this.valueMarshallable = Marshallable.class.isAssignableFrom(mapView.valueType());
        this.valueMap = Map.class.isAssignableFrom(mapView.valueType());
    }

    @Override
    public void registerChangeListener(@NotNull Runnable r) {
        this.mapView.registerSubscriber(o -> r.run());
    }

    private Comparator<Map.Entry<K, V>> sort(@NotNull List<ColumnViewInternal.MarshableOrderBy> marshableOrderBy) {
        return (o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            for (ColumnViewInternal.MarshableOrderBy order : marshableOrderBy) {
                Object c2;
                Object c1;
                int result;
                block10: {
                    String column = order.column;
                    result = 0;
                    if (column.equals("key")) {
                        c1 = o1.getKey();
                        c2 = o2.getKey();
                    } else if (this.valueMap) {
                        c1 = ((Map)((Object)o1)).get(column);
                        c2 = ((Map)((Object)o2)).get(column);
                    } else {
                        if (this.valueMarshallable) {
                            try {
                                FieldInfo field = Wires.fieldInfo(o1.getValue().getClass(), (String)column);
                                c1 = field.get(o1.getValue());
                                c2 = field.get(o2.getValue());
                                break block10;
                            }
                            catch (Exception e) {
                                Jvm.warn().on(MapWrappingColumnView.class, (Throwable)e);
                                continue;
                            }
                        }
                        if (!column.equals("value")) continue;
                        c1 = o1.getValue();
                        c2 = o2.getValue();
                    }
                }
                if ((result = c1.getClass() == c2.getClass() && c1 instanceof Comparable && !(c1 instanceof CharSequence) ? ((Comparable)c1).compareTo(c2) : String.CASE_INSENSITIVE_ORDER.compare(c1.toString(), c2.toString())) == 0) continue;
                return order.isAscending ? -result : result;
            }
            return 0;
        };
    }

    @NotNull
    public ClosableIterator<Row> iterator(@NotNull ColumnViewInternal.SortedFilter sortedFilter) {
        final Iterator core = this.mapView.entrySet().stream().filter(this.filter(sortedFilter.marshableFilters)).sorted(this.sort(sortedFilter.marshableOrderBy)).iterator();
        ClosableIterator<Row> result = new ClosableIterator<Row>(){

            public void close() {
            }

            @Override
            public boolean hasNext() {
                return core.hasNext();
            }

            @Override
            @NotNull
            public Row next() {
                Map.Entry e = (Map.Entry)core.next();
                Row row = new Row(MapWrappingColumnView.this.columns());
                this.addColumns(row, MapWrappingColumnView.this.mapView.keyType(), "key", e.getKey());
                this.addColumns(row, MapWrappingColumnView.this.mapView.valueType(), "value", e.getValue());
                return row;
            }

            private void addColumns(@NotNull Row row, Class type, String defaultColumnName, Object item) {
                List fieldInfos = Wires.fieldInfos((Class)type);
                if (fieldInfos.isEmpty()) {
                    row.set(defaultColumnName, item);
                } else {
                    Marshallable value = (Marshallable)item;
                    for (FieldInfo info : fieldInfos) {
                        if (!MapWrappingColumnView.this.columnNames().contains(info.name())) continue;
                        try {
                            Object newValue = info.get((Object)value);
                            row.set(info.name(), newValue);
                        }
                        catch (Exception e1) {
                            Jvm.warn().on(VanillaMapView.class, (Throwable)e1);
                        }
                    }
                }
            }
        };
        long x = 0L;
        while (x++ < sortedFilter.fromIndex && result.hasNext()) {
            result.next();
        }
        return result;
    }

    @Override
    public boolean containsRowWithKey(@NotNull List keys) {
        assert (keys.size() == 1);
        return this.mapView.containsKey(keys.get(0));
    }

    @Override
    @Nullable
    public ObjectSubscription objectSubscription() {
        return this.mapView.asset().getView(ObjectSubscription.class);
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    @NotNull
    public List<Column> columns() {
        ArrayList<Column> result = new ArrayList<Column>();
        if (Marshallable.class.isAssignableFrom(this.keyType())) {
            for (FieldInfo info : Wires.fieldInfos(this.keyType())) {
                result.add(new Column(info.name(), true, true, "", info.type(), true));
            }
        } else {
            result.add(new Column("key", true, true, "", this.keyType(), true));
        }
        boolean isReadOnly = this.requestContext.toUri().startsWith("/proc");
        if (Marshallable.class.isAssignableFrom(this.valueType())) {
            for (FieldInfo info : Wires.fieldInfos(this.valueType())) {
                result.add(new Column(info.name(), isReadOnly, false, "", info.type(), true));
            }
        } else {
            result.add(new Column("value", isReadOnly, false, "", this.valueType(), true));
        }
        return result;
    }

    private Class<?> keyType() {
        return this.mapView.keyType();
    }

    @Nullable
    private ArrayList<String> columnNames() {
        if (this.columnNames != null) {
            return this.columnNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (Marshallable.class.isAssignableFrom(this.keyType())) {
            for (FieldInfo fi : Wires.fieldInfos(this.keyType())) {
                result.add(fi.name());
            }
        } else {
            result.add("key");
        }
        if (Marshallable.class.isAssignableFrom(this.valueType())) {
            for (FieldInfo fi : Wires.fieldInfos(this.valueType())) {
                result.add(fi.name());
            }
        } else {
            result.add("value");
        }
        this.columnNames = new ArrayList(result);
        return this.columnNames;
    }

    private Class<V> valueType() {
        return this.mapView.valueType();
    }

    @Override
    public boolean canDeleteRows() {
        return !this.requestContext.toUri().startsWith("/proc");
    }

    @Override
    public int changedRow(@NotNull Map<String, Object> row, @NotNull Map<String, Object> oldRow) {
        Class<V> valueType;
        assert (row.isEmpty() && oldRow.isEmpty()) : "both rows can not be empty";
        if (row.isEmpty()) {
            Object k = oldRow.get("key");
            if (k == null) {
                throw new IllegalStateException("key not found");
            }
            return this.mapView.remove(k) == null ? 0 : 1;
        }
        Object oldKey = oldRow.get("key");
        Object newKey = row.get("key");
        if (oldKey != null && !oldKey.equals(newKey)) {
            this.mapView.remove(oldKey);
        }
        if (!Marshallable.class.isAssignableFrom(valueType = this.mapView.valueType())) {
            if (!row.containsKey("value")) {
                throw new IllegalStateException("value not found");
            }
            assert (row.size() == 2);
            assert (oldRow.size() == 2);
            this.mapView.put(newKey, row.get("value"));
            return 1;
        }
        Object v = ObjectUtils.newInstance(valueType);
        for (Map.Entry<String, Object> e : row.entrySet()) {
            if ("key".equals(e.getKey())) continue;
            FieldInfo fi = Wires.fieldInfo(valueType, (String)e.getKey());
            fi.set(v, e.getValue());
        }
        this.mapView.put(newKey, v);
        return 1;
    }

    @Nullable
    private Predicate<Map.Entry<K, V>> filter(@NotNull List<ColumnViewInternal.MarshableFilter> filters) {
        Predicate<Number> predicate = this.predicate(filters);
        return entry -> {
            if (filters.isEmpty()) {
                return true;
            }
            try {
                for (ColumnViewInternal.MarshableFilter f : filters) {
                    Object item;
                    if ("key".equals(f.columnName)) {
                        item = entry.getKey();
                    } else if (!Marshallable.class.isAssignableFrom(this.mapView.valueType()) && "value".equals(f.columnName)) {
                        item = entry.getValue();
                    } else if (Marshallable.class.isAssignableFrom(this.mapView.valueType())) {
                        try {
                            Class<?> valueClass = entry.getValue().getClass();
                            FieldInfo info = Wires.fieldInfo(valueClass, (String)f.columnName);
                            Object o = info.get(entry.getValue());
                            if (o == null) {
                                return false;
                            }
                            if (o instanceof Number) {
                                if (predicate.test((Number)o)) continue;
                                return false;
                            }
                            item = o;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    if (!(item instanceof CharSequence ? !item.toString().toLowerCase().contains(f.filter.toLowerCase()) : (item instanceof Number ? !predicate.test((Number)item) : !item.equals(ObjectUtils.convertTo(item.getClass(), (Object)f.filter.trim()))))) continue;
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    @Override
    public int rowCount(@Nullable ColumnViewInternal.SortedFilter sortedFilter) {
        if (sortedFilter == null || sortedFilter.marshableFilters.isEmpty()) {
            return (int)this.mapView.longSize();
        }
        return (int)this.mapView.entrySet().stream().filter(this.filter(sortedFilter.marshableFilters)).count();
    }
}

