/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EngineHostDetails
extends HostDetails
implements Marshallable,
Closeable {
    private final Map<InetSocketAddress, TcpChannelHub> tcpChannelHubs = new ConcurrentHashMap<InetSocketAddress, TcpChannelHub>();

    EngineHostDetails() {
    }

    public EngineHostDetails(int hostId, int tcpBufferSize, @NotNull String connectUri) {
        this.hostId(hostId);
        this.tcpBufferSize(tcpBufferSize);
        this.connectUri(connectUri);
    }

    public void close() {
        this.tcpChannelHubs.values().forEach(Closeable::closeQuietly);
    }

    public TcpChannelHub tcpChannelHub() {
        return this.tcpChannelHubs.get(TCPRegistry.lookup((String)this.connectUri()));
    }

    private class SimpleSessionProvider
    implements SessionProvider {
        @Nullable
        private final SessionDetails sessionDetails;

        SimpleSessionProvider(SessionDetails sessionDetails) {
            this.sessionDetails = sessionDetails == null ? VanillaSessionDetails.of((String)"", (String)"", (String)"") : sessionDetails;
        }

        @Nullable
        public SessionDetails get() {
            return this.sessionDetails;
        }

        public void set(@NotNull SessionDetails sessionDetails) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

