/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.fs.EngineCluster;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Clusters
extends AbstractMarshallable
implements Marshallable,
Closeable {
    private final Map<String, EngineCluster> clusterMap = new ConcurrentSkipListMap<String, EngineCluster>();

    public Clusters() {
    }

    public Clusters(@NotNull Map<String, EngineCluster> clusterMap) {
        this.clusterMap.putAll(clusterMap);
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        StringBuilder clusterName = Wires.acquireStringBuilder();
        while (!wire.isEmpty()) {
            wire.readEventName(clusterName).marshallable(host -> {
                EngineCluster engineCluster = this.clusterMap.computeIfAbsent(clusterName.toString(), EngineCluster::new);
                engineCluster.readMarshallable(host);
            });
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, EngineCluster> entry : this.clusterMap.entrySet()) {
            wire.writeEventName(entry::getKey).marshallable((WriteMarshallable)entry.getValue());
        }
    }

    public void install(@NotNull AssetTree assetTree) {
        Asset root = assetTree.root();
        root.addView(Clusters.class, this);
        if (this.clusterMap == null) {
            return;
        }
        this.clusterMap.values().forEach(v -> {
            v.assetRoot(root);
            v.install();
        });
    }

    public EngineCluster get(String cluster) {
        return this.clusterMap.get(cluster);
    }

    public EngineCluster firstCluster() {
        return this.clusterMap.values().iterator().next();
    }

    public void put(String clusterName, EngineCluster engineCluster) {
        this.clusterMap.put(clusterName, engineCluster);
    }

    public void close() {
        this.clusterMap.values().forEach(Closeable::closeQuietly);
    }

    public void notifyClosing() {
        this.clusterMap.values().forEach(Closeable::notifyClosing);
    }

    public int size() {
        return this.clusterMap.size();
    }
}

