/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.util.function.Function;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.query.QueueConfig;
import net.openhft.chronicle.engine.tree.MessageAdaptor;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.wire.AbstractMarshallableCfg;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueCfg
extends AbstractMarshallableCfg
implements Installable {
    private int masterId = 1;
    private String basePath = null;
    private Class topicClass = String.class;
    private Class messageClass = String.class;
    private boolean acknowledgment = false;
    private MessageAdaptor messageAdaptor = null;
    private WireType wireType = WireType.BINARY;
    private String cluster = "";

    @Override
    @Nullable
    public Void install(@NotNull String uriPath, @NotNull AssetTree assetTree) throws Exception {
        RequestContext requestContext = RequestContext.requestContext(uriPath);
        if (requestContext.bootstrap() != null) {
            throw new UnsupportedOperationException("Its not possible to set the bootstrap when acquiring a queue");
        }
        Function<String, Integer> queueSource = s -> s.equals(uriPath) ? this.masterId : 1;
        Asset asset = assetTree.acquireAsset(uriPath);
        ((VanillaAsset)asset).configQueueServer();
        QueueConfig qc = asset.getView(QueueConfig.class);
        if (qc == null) {
            asset.addView(new QueueConfig(queueSource, this.acknowledgment, this.messageAdaptor, this.wireType));
        }
        assetTree.acquireView(requestContext.view("queue").type(this.topicClass).type2(this.messageClass).basePath(this.basePath).cluster(this.cluster));
        return null;
    }
}

