/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import java.net.URISyntaxException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.cfg.SubscriptionStat;
import net.openhft.chronicle.engine.cfg.UserStat;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.wire.AbstractMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCfg
extends AbstractMarshallable
implements Installable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorCfg.class);
    private boolean subscriptionMonitoringEnabled;
    private boolean userMonitoringEnabled;

    @Override
    @NotNull
    public MonitorCfg install(@NotNull String path, @NotNull AssetTree assetTree) throws IOException, URISyntaxException {
        ((VanillaAsset)assetTree.acquireAsset("/proc")).configMapServer();
        if (this.subscriptionMonitoringEnabled) {
            LOGGER.info("Enabling Subscription Monitoring for " + assetTree);
            assetTree.acquireMap("/proc/subscriptions", String.class, SubscriptionStat.class);
        }
        if (this.userMonitoringEnabled) {
            LOGGER.info("Enabling User Monitoring for " + assetTree);
            assetTree.acquireMap("/proc/users", String.class, UserStat.class);
        }
        return this;
    }
}

