/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMapCfg
implements Installable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryMapCfg.class);
    private Class keyType;
    private Class valueType;
    private boolean putReturnsNull;
    private boolean removeReturnsNull;
    private String compression;
    private String importFile;

    @Override
    @Nullable
    public Void install(@NotNull String path, @NotNull AssetTree assetTree) throws IOException {
        String uri = path + "?putReturnsNull=" + this.putReturnsNull + "&removeReturnsNull=" + this.removeReturnsNull;
        MapView<Object, Object> mapView = assetTree.acquireMap(uri, this.keyType, this.valueType);
        if (this.importFile != null) {
            Wire wire = Wire.fromFile((String)this.importFile);
            StringBuilder keyStr = new StringBuilder();
            while (!wire.isEmpty()) {
                Object value = wire.readEventName(keyStr).object(this.valueType);
                Object key = ObjectUtils.convertTo((Class)this.keyType, (Object)keyStr);
                mapView.put(key, value);
            }
        }
        LOGGER.info("Added InMemoryMap " + path + ", size: " + mapView.size());
        return null;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "keyType").typeLiteral((Object)this, (o, c) -> {
            o.keyType = c;
        }).read(() -> "valueType").typeLiteral((Object)this, (o, c) -> {
            o.valueType = c;
        }).read(() -> "compression").text((Object)this, (o, c) -> {
            o.compression = c;
        }).read(() -> "putReturnsNull").bool((Object)this, (o, e) -> {
            o.putReturnsNull = e;
        }).read(() -> "removeReturnsNull").bool((Object)this, (o, e) -> {
            o.removeReturnsNull = e;
        });
        while (!wire.isEmpty()) {
            wire.read(() -> "import").text((Object)this, (o, s) -> {
                o.importFile = s;
            });
        }
    }

    @NotNull
    public String toString() {
        return "InMemoryMapCfg{keyType=" + this.keyType + ", valueType=" + this.valueType + ", putReturnsNull=" + this.putReturnsNull + ", removeReturnsNull=" + this.removeReturnsNull + ", compression='" + this.compression + '\'' + ", importFile='" + this.importFile + '\'' + '}';
    }
}

