/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.function.Function;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.engine.HeartbeatHandler;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.cfg.VanillaWireOutPublisherFactory;
import net.openhft.chronicle.engine.fs.EngineConnectionManager;
import net.openhft.chronicle.engine.server.internal.EngineNetworkStatsListener;
import net.openhft.chronicle.engine.server.internal.EngineWireHandler;
import net.openhft.chronicle.engine.server.internal.EngineWireNetworkContext;
import net.openhft.chronicle.engine.server.internal.UberHandler;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.network.HeaderTcpHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.WireTypeSniffingTcpHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HostIdConnectionStrategy;
import net.openhft.chronicle.network.connection.VanillaWireOutPublisher;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineClusterContext
extends ClusterContext {
    private static final Logger LOG = LoggerFactory.getLogger(EngineClusterContext.class);
    Asset assetRoot;
    private byte localIdentifier;
    @NotNull
    private NetworkStatsListener defaultNetworkStatsListener = new NetworkStatsListener(){
        String host;
        long port;

        public void close() {
            LOG.info("writeKBps=0, readKBps=0, socketPollCountPerSecond=0, host=" + this.host + ", port=" + this.port + ", isConnected=false");
        }

        public void networkContext(NetworkContext networkContext) {
        }

        public void onNetworkStats(long writeBps, long readBps, long socketPollCountPerSecond) {
            LOG.info("writeKBps=" + writeBps / 1000L + ", readKBps=" + readBps / 1000L + ", socketPollCountPerSecond=" + socketPollCountPerSecond + ", host=" + this.host + ", port=" + this.port + ", isConnected=true");
        }

        public void onHostPort(String hostName, int port) {
            this.host = hostName;
            this.port = port;
        }

        public void onRoundTripLatency(long nanosecondLatency) {
        }
    };

    @UsedViaReflection
    private EngineClusterContext(@NotNull WireIn w) {
        super(w);
    }

    public EngineClusterContext() {
    }

    @Nullable
    public ThrowingFunction<NetworkContext, TcpEventHandler, IOException> tcpEventHandlerFactory() {
        return networkContext -> {
            NetworkStatsListener nl;
            EngineWireNetworkContext nc = (EngineWireNetworkContext)((Object)networkContext);
            if (nc.isAcceptor()) {
                nc.wireOutPublisher((WireOutPublisher)new VanillaWireOutPublisher(WireType.TEXT));
            }
            networkContext.serverThreadingStrategy(ServerThreadingStrategy.CONCURRENT);
            TcpEventHandler handler = new TcpEventHandler(networkContext);
            Function<Object, TcpHandler> consumer = o -> {
                if (o instanceof SessionDetailsProvider) {
                    SessionDetailsProvider sessionDetails = (SessionDetailsProvider)o;
                    nc.heartbeatTimeoutMs(this.heartbeatTimeoutMs());
                    nc.sessionDetails(sessionDetails);
                    nc.wireType(sessionDetails.wireType());
                    WireType wireType = nc.sessionDetails().wireType();
                    if (wireType != null) {
                        nc.wireOutPublisher().wireType(wireType);
                    }
                    return new EngineWireHandler();
                }
                if (o instanceof TcpHandler) {
                    return (TcpHandler)o;
                }
                throw new UnsupportedOperationException("not supported class=" + o.getClass());
            };
            if (nc.networkStatsListener() == null) {
                nc.networkStatsListener(this.defaultNetworkStatsListener);
            }
            if ((nl = nc.networkStatsListener()) != null) {
                NetworkStatsListener.notifyHostPort((SocketChannel)nc.socketChannel(), (NetworkStatsListener)nl);
            }
            Function<EngineWireNetworkContext, TcpHandler> f = x -> new HeaderTcpHandler(handler, consumer, (NetworkContext)x);
            WireTypeSniffingTcpHandler sniffer = new WireTypeSniffingTcpHandler(handler, f);
            handler.tcpHandler((TcpHandler)sniffer);
            return handler;
        };
    }

    public Asset assetRoot() {
        return this.assetRoot;
    }

    @NotNull
    public EngineClusterContext assetRoot(@NotNull Asset assetRoot) {
        this.assetRoot = assetRoot;
        this.localIdentifier = HostIdentifier.localIdentifier(assetRoot);
        this.localIdentifier(this.localIdentifier);
        this.eventLoop(assetRoot.findOrCreateView(EventLoop.class));
        return this;
    }

    public void defaults() {
        this.wireType(WireType.TEXT);
        this.handlerFactory(new UberHandler.Factory());
        this.wireOutPublisherFactory((Function)((Object)new VanillaWireOutPublisherFactory()));
        this.networkContextFactory((Function)((Object)new EngineWireNetworkContext.Factory()));
        this.networkStatsListenerFactory((Function)((Object)new EngineNetworkStatsListener.Factory()));
        this.connectionEventHandler(new EngineConnectionManager.Factory());
        this.heartbeatFactory(new HeartbeatHandler.Factory());
        this.heartbeatTimeoutMs(5000L);
        this.heartbeatIntervalMs(1000L);
        this.connectionStrategy((ConnectionStrategy)new HostIdConnectionStrategy());
        this.serverThreadingStrategy(ServerThreadingStrategy.SINGLE_THREADED);
    }
}

