/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.tree;

import java.io.File;
import java.util.Set;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.management.ManagementTools;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTreeStats;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import net.openhft.chronicle.engine.query.Filter;
import net.openhft.chronicle.engine.tree.QueueView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AssetTree
extends Closeable {
    @NotNull
    public Asset root();

    @Nullable
    public Asset getAsset(String var1);

    @NotNull
    public Asset acquireAsset(@NotNull String var1) throws AssetNotFoundException;

    @NotNull
    default public <E> Set<E> acquireSet(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return (Set)this.acquireView(RequestContext.requestContext(uri).view("set").type(eClass));
    }

    @NotNull
    default public <K, V> MapView<K, V> acquireMap(@NotNull String uri, Class<K> kClass, Class<V> vClass) throws AssetNotFoundException {
        RequestContext requestContext = RequestContext.requestContext(uri);
        if (requestContext.bootstrap() != null) {
            throw new UnsupportedOperationException("Its not possible to set the bootstrap when acquiring a map");
        }
        return (MapView)this.acquireView(requestContext.view("map").type(kClass).type2(vClass));
    }

    @NotNull
    default public <E> Publisher<E> acquirePublisher(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return (Publisher)this.acquireView(RequestContext.requestContext(uri).view("pub").elementType(eClass));
    }

    @NotNull
    default public <E> Publisher<E> acquirePublisher(@NotNull String uri, String basePath, Class<E> eClass) throws AssetNotFoundException {
        return (Publisher)this.acquireView(RequestContext.requestContext(uri).view("pub").elementType(eClass).basePath(basePath));
    }

    @NotNull
    default public <E> Reference<E> acquireReference(@NotNull String uri, Class<E> eClass) throws AssetNotFoundException {
        return (Reference)this.acquireView(RequestContext.requestContext(uri).view("ref").type(eClass));
    }

    @NotNull
    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(@NotNull String uri) throws AssetNotFoundException {
        return (TopicPublisher)this.acquireView(RequestContext.requestContext(uri).view("topicPub"));
    }

    @NotNull
    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(@NotNull String uri, Class<T> topicClass, Class<E> messageClass) throws AssetNotFoundException {
        return (TopicPublisher)this.acquireView(RequestContext.requestContext(uri).view("topicPub").type(topicClass).type2(messageClass));
    }

    @NotNull
    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(@NotNull String uri, String basePath, Class<T> topicClass, Class<E> messageClass) throws AssetNotFoundException {
        return (TopicPublisher)this.acquireView(RequestContext.requestContext(uri).view("topicPub").type(topicClass).type2(messageClass).basePath(basePath));
    }

    @NotNull
    default public <T, E> TopicPublisher<T, E> acquireTopicPublisher(@NotNull String uri, File baseDir, Class<T> topicClass, Class<E> messageClass) throws AssetNotFoundException {
        return this.acquireTopicPublisher(uri, baseDir.getAbsolutePath(), topicClass, messageClass);
    }

    default public <E> void registerSubscriber(@NotNull String uri, Class<E> eClass, @NotNull Subscriber<E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).type2(eClass);
        this.acquireSubscription(rc).registerSubscriber(rc, subscriber, Filter.empty());
    }

    default public <E> void registerSubscriber(@NotNull String uri, String basePath, Class<E> eClass, @NotNull Subscriber<E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).type2(eClass).basePath(basePath);
        this.acquireSubscription(rc).registerSubscriber(rc, subscriber, Filter.empty());
    }

    default public <T, E> void registerTopicSubscriber(@NotNull String uri, Class<T> topicClass, Class<E> messageClass, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).keyType(topicClass).valueType(messageClass);
        KVSSubscription kvsSubscription = (KVSSubscription)this.acquireSubscription(rc);
        kvsSubscription.registerTopicSubscriber(rc, subscriber);
    }

    default public <T, E> void registerTopicSubscriber(@NotNull String uri, String basePath, Class<T> topicClass, Class<E> messageClass, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).keyType(topicClass).valueType(messageClass).basePath(basePath);
        KVSSubscription kvsSubscription = (KVSSubscription)this.acquireSubscription(rc);
        kvsSubscription.registerTopicSubscriber(rc, subscriber);
    }

    default public <T, E> void registerTopicSubscriber(@NotNull String uri, File baseFile, Class<T> topicClass, Class<E> messageClass, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        this.registerTopicSubscriber(uri, baseFile.getAbsolutePath(), topicClass, messageClass, subscriber);
    }

    @NotNull
    default public SubscriptionCollection acquireSubscription(@NotNull RequestContext requestContext) throws AssetNotFoundException {
        Asset asset = this.acquireAsset(requestContext.fullName());
        Class<SubscriptionCollection> subscriptionType = requestContext.getSubscriptionType();
        requestContext.viewType(subscriptionType);
        return asset.acquireView(subscriptionType, requestContext);
    }

    default public <E> void unregisterSubscriber(@NotNull String uri, @NotNull Subscriber<E> subscriber) {
        RequestContext rc = RequestContext.requestContext(uri);
        SubscriptionCollection subscription = this.getSubscription(rc);
        if (subscription == null) {
            subscriber.onEndOfSubscription();
        } else {
            subscription.unregisterSubscriber(subscriber);
        }
    }

    default public <T, E> void unregisterTopicSubscriber(@NotNull String uri, @NotNull TopicSubscriber<T, E> subscriber) throws AssetNotFoundException {
        RequestContext rc = RequestContext.requestContext(uri).viewType(Subscriber.class);
        SubscriptionCollection subscription = this.getSubscription(rc);
        if (subscription instanceof KVSSubscription) {
            ((KVSSubscription)subscription).unregisterTopicSubscriber(subscriber);
        } else {
            subscriber.onEndOfSubscription();
        }
    }

    @Nullable
    default public SubscriptionCollection getSubscription(@NotNull RequestContext requestContext) {
        Asset asset = this.getAsset(requestContext.fullName());
        Class<SubscriptionCollection> subscriptionType = requestContext.getSubscriptionType();
        requestContext.viewType(subscriptionType);
        return asset == null ? null : asset.getView(subscriptionType);
    }

    @NotNull
    default public <S> S acquireService(@NotNull String uri, Class<S> serviceType) throws AssetNotFoundException {
        return (S)this.acquireView(RequestContext.requestContext(uri).viewType(serviceType));
    }

    @NotNull
    default public <E> E acquireView(@NotNull RequestContext requestContext) throws AssetNotFoundException {
        Asset asset = this.acquireAsset(requestContext.fullName());
        return (E)asset.acquireView(requestContext);
    }

    @NotNull
    default public AssetTree enableManagement() {
        ManagementTools.enableManagement(this);
        return this;
    }

    @NotNull
    default public AssetTree enableManagement(int port) {
        ManagementTools.enableManagement(this, port);
        return this;
    }

    @NotNull
    default public AssetTree disableManagement() {
        ManagementTools.disableManagement(this);
        return this;
    }

    public AssetTreeStats getUsageStats();

    @NotNull
    default public <T, M> QueueView<T, M> acquireQueue(@NotNull String uri, Class<T> typeClass, Class<M> messageClass, String cluster) {
        RequestContext requestContext = RequestContext.requestContext(uri);
        if (requestContext.bootstrap() != null) {
            throw new UnsupportedOperationException("Its not possible to set the bootstrap when acquiring a queue");
        }
        return (QueueView)this.acquireView(requestContext.view("queue").type(typeClass).type2(messageClass).cluster(cluster));
    }

    @NotNull
    default public <T, M> QueueView<T, M> acquireQueue(@NotNull String uri, Class<T> typeClass, Class<M> messageClass, String cluster, String basePath) {
        RequestContext requestContext = RequestContext.requestContext(uri).basePath(basePath);
        if (requestContext.bootstrap() != null) {
            throw new UnsupportedOperationException("Its not possible to set the bootstrap when acquiring a queue");
        }
        return (QueueView)this.acquireView(requestContext.view("queue").type(typeClass).type2(messageClass).cluster(cluster));
    }

    @NotNull
    default public <T, M> QueueView<T, M> acquireQueue(@NotNull String uri, String basePath, Class<T> typeClass, Class<M> messageClass, String cluster) {
        RequestContext requestContext = RequestContext.requestContext(uri).basePath(basePath);
        if (requestContext.bootstrap() != null) {
            throw new UnsupportedOperationException("Its not possible to set the bootstrap when acquiring a queue");
        }
        return (QueueView)this.acquireView(requestContext.view("queue").type(typeClass).type2(messageClass).cluster(cluster));
    }
}

