/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.query;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.engine.api.query.IndexQuery;
import net.openhft.chronicle.engine.map.QueueObjectSubscription;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.compiler.CompilerUtils;
import net.openhft.lang.model.DataValueGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaIndexQuery<V>
extends AbstractMarshallable
implements Demarshallable,
IndexQuery<V> {
    private static final Logger LOG = LoggerFactory.getLogger(QueueObjectSubscription.class);
    private Class<V> valueClass;
    private String select;
    private String eventName;
    private long from;
    private boolean bootstrap = true;

    public VanillaIndexQuery() {
    }

    @UsedViaReflection
    public VanillaIndexQuery(@NotNull WireIn wire) {
        this.readMarshallable(wire);
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        Wires.readMarshallable((Object)this, (WireIn)wire, (boolean)false);
    }

    public Class<V> valueClass() {
        return this.valueClass;
    }

    @NotNull
    public String select() {
        return this.select == null ? "" : this.select;
    }

    @Override
    public String eventName() {
        return this.eventName;
    }

    public void eventName(String eventName) {
        this.eventName = eventName;
    }

    @NotNull
    public VanillaIndexQuery select(@NotNull Class valueClass, @NotNull String select) {
        this.select = select;
        this.valueClass = valueClass;
        try {
            ClassCache.newInstance0(new ClassCache.TypedSelect(valueClass, select), "TestCompile");
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), e.getMessage());
        }
        return this;
    }

    @Override
    public boolean bootstrap() {
        return this.bootstrap;
    }

    @Override
    public long fromIndex() {
        return this.from;
    }

    @NotNull
    public IndexQuery<V> fromIndex(long from) {
        this.from = from;
        return this;
    }

    @Override
    public Predicate<V> filter() {
        return ClassCache.newInstance(this.valueClass, this.select);
    }

    @NotNull
    public String toString() {
        return "VanillaMarshableQuery{valueClass=" + this.valueClass + ", select='" + this.select + '\'' + ", eventName='" + this.eventName + '\'' + ", from=" + Long.toHexString(this.from) + '}';
    }

    public VanillaIndexQuery bootstrap(boolean bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    private static class ClassCache {
        private static final ConcurrentMap<TypedSelect, Predicate> cache = new ConcurrentHashMap<TypedSelect, Predicate>();
        @NotNull
        private static AtomicLong uniqueClassId = new AtomicLong();
        private static Pattern p = Pattern.compile("\"");
        private static ThreadLocal<StringBuffer> sbTl = ThreadLocal.withInitial(StringBuffer::new);

        private ClassCache() {
        }

        private static Predicate newInstance(Class clazz0, String select) {
            return cache.computeIfAbsent(new TypedSelect(clazz0, select), ClassCache::newInstanceAutoGenerateClassName);
        }

        private static <V> Predicate<V> newInstanceAutoGenerateClassName(@NotNull TypedSelect typedSelect) {
            return ClassCache.newInstance0(typedSelect, "AutoGeneratedPredicate" + uniqueClassId.incrementAndGet());
        }

        private static CharSequence escapeQuotes(@NotNull String source) {
            Matcher m = p.matcher(source);
            StringBuffer sb = sbTl.get();
            sb.setLength(0);
            while (m.find()) {
                m.appendReplacement(sb, "\\\\\"");
            }
            m.appendTail(sb);
            return sb;
        }

        private static <V> Predicate<V> newInstance0(@NotNull TypedSelect typedSelect, String className) {
            String clazz = typedSelect.clazz.getName();
            String select = typedSelect.select;
            CharSequence toString = select.contains("\"") ? ClassCache.escapeQuotes(select) : select;
            String source = "package net.openhft.chronicle.engine.api.query;\npublic class " + className + " implements " + "java.util.function.Predicate<" + clazz + "> {\n\tpublic " + "boolean test(" + clazz + " value) " + "{\n\t\treturn " + typedSelect.select + ";\n\t}\n\n\tpublic String toString(){\n\t\treturn \"" + toString + "\";\n\t}\n}";
            LoggerFactory.getLogger(DataValueGenerator.class).info(source);
            ClassLoader classLoader = ClassCache.class.getClassLoader();
            try {
                Class clazzP = CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, "net.openhft.chronicle.engine.api.query." + className, source);
                return (Predicate)clazzP.newInstance();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        static class TypedSelect
        extends AbstractMarshallable {
            private String select;
            private Class clazz;

            private TypedSelect(Class clazz, String select) {
                this.select = select;
                this.clazz = clazz;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof TypedSelect)) {
                    return false;
                }
                TypedSelect that = (TypedSelect)((Object)o);
                if (this.select != null ? !this.select.equals(that.select) : that.select != null) {
                    return false;
                }
                return this.clazz != null ? this.clazz.equals(that.clazz) : that.clazz == null;
            }

            public int hashCode() {
                int result = this.select != null ? this.select.hashCode() : 0;
                result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
                return result;
            }
        }
    }
}

