/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EngineReplication
extends Replication {
    public static final String ENGINE_REPLICATION_COMPRESSION = System.getProperty("EngineReplication.Compression");

    public byte identifier();

    @Override
    @Nullable
    public ModificationIterator acquireModificationIterator(byte var1);

    @Override
    public long lastModificationTime(byte var1);

    @Override
    public void setLastModificationTime(byte var1, long var2);

    public static interface ReplicationEntry
    extends Marshallable {
        @Nullable
        public BytesStore key();

        @Nullable
        public BytesStore value();

        public long timestamp();

        public byte identifier();

        public byte remoteIdentifier();

        public boolean isDeleted();

        public long bootStrapTimeStamp();

        default public void key(BytesStore key) {
            throw new UnsupportedOperationException("immutable entry");
        }

        default public void value(BytesStore key) {
            throw new UnsupportedOperationException("immutable entry");
        }

        default public void timestamp(long timestamp) {
            throw new UnsupportedOperationException("immutable entry");
        }

        default public void identifier(byte identifier) {
            throw new UnsupportedOperationException("immutable entry");
        }

        default public void isDeleted(boolean isDeleted) {
            throw new UnsupportedOperationException("immutable entry");
        }

        default public void bootStrapTimeStamp(long bootStrapTimeStamp) {
            throw new UnsupportedOperationException("immutable entry");
        }

        default public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
            this.key(wire.read(() -> "key").bytesStore());
            this.value(wire.read(() -> "value").bytesStore());
            this.timestamp(wire.read(() -> "timestamp").int64());
            this.identifier(wire.read(() -> "identifier").int8());
            this.isDeleted(wire.read(() -> "isDeleted").bool());
            this.bootStrapTimeStamp(wire.read(() -> "bootStrapTimeStamp").int64());
        }

        default public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "key").bytes(this.key());
            if (ENGINE_REPLICATION_COMPRESSION != null && this.value() != null) {
                wire.write(() -> "value").compress(ENGINE_REPLICATION_COMPRESSION, this.value().bytesForRead());
            } else {
                wire.write(() -> "value").bytes(this.value());
            }
            wire.write(() -> "timestamp").int64(this.timestamp());
            wire.write(() -> "identifier").int8(this.identifier());
            wire.write(() -> "isDeleted").bool(Boolean.valueOf(this.isDeleted()));
            wire.write(() -> "bootStrapTimeStamp").int64(this.bootStrapTimeStamp());
            wire.writeComment((CharSequence)("remoteIdentifier=" + this.remoteIdentifier()));
        }
    }

    @FunctionalInterface
    public static interface EntryCallback {
        public boolean onEntry(@NotNull ReplicationEntry var1);
    }

    public static interface ModificationIterator {
        public boolean hasNext();

        public boolean nextEntry(Consumer<ReplicationEntry> var1);

        public void dirtyEntries(long var1);

        public void setModificationNotifier(@NotNull ModificationNotifier var1);
    }

    @FunctionalInterface
    public static interface ModificationNotifier {
        public static final ModificationNotifier NOP = () -> {};

        public void onChange();
    }
}

