/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.PrintExceptionHandler;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.cfg.EngineCfg;
import net.openhft.chronicle.engine.cfg.EngineClusterContext;
import net.openhft.chronicle.engine.fs.Clusters;
import net.openhft.chronicle.engine.fs.EngineCluster;
import net.openhft.chronicle.engine.fs.EngineHostDetails;
import net.openhft.chronicle.engine.map.CMap2EngineReplicator;
import net.openhft.chronicle.engine.map.ChronicleMapKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.query.QueueConfig;
import net.openhft.chronicle.engine.server.ServerEndpoint;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.VanillaAssetTree;
import net.openhft.chronicle.network.NetworkStats;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineInstance {
    static final Logger LOGGER = LoggerFactory.getLogger(EngineInstance.class);

    public static VanillaAssetTree engineMain(int hostId, String yamlConfigFile) {
        try {
            TextWire yaml = TextWire.fromFile((String)yamlConfigFile);
            EngineCfg installable = (EngineCfg)yaml.readObject();
            VanillaAssetTree tree = new VanillaAssetTree(hostId).forServer(false);
            Asset connectivityMap = tree.acquireAsset("/proc/connections/cluster/connectivity");
            connectivityMap.addWrappingRule(MapView.class, "map directly to KeyValueStore", VanillaMapView::new, KeyValueStore.class);
            connectivityMap.addLeafRule(EngineReplication.class, "Engine replication holder", CMap2EngineReplicator::new);
            connectivityMap.addLeafRule(KeyValueStore.class, "KVS is Chronicle Map", (context, asset) -> new ChronicleMapKeyValueStore(context.cluster(EngineInstance.firstClusterName(tree)), asset));
            try {
                installable.install("/", tree);
                LOGGER.info("Engine started");
            }
            catch (Exception e2) {
                LOGGER.error("Error starting a component, stopping", (Throwable)e2);
                tree.close();
            }
            Clusters clusters = tree.root().getView(Clusters.class);
            if (clusters == null || clusters.size() == 0) {
                Jvm.warn().on(EngineInstance.class, "cluster not found");
                return null;
            }
            if (clusters.size() != 1) {
                Jvm.warn().on(EngineInstance.class, "unambiguous cluster, you have " + clusters.size() + " clusters which one do you want to use?");
                return null;
            }
            EngineCluster engineCluster = clusters.firstCluster();
            HostDetails hostDetails = engineCluster.findHostDetails(hostId);
            String connectUri = hostDetails.connectUri();
            ((EngineClusterContext)engineCluster.clusterContext()).assetRoot(tree.root());
            NetworkStatsListener networkStatsListener = (NetworkStatsListener)((EngineClusterContext)engineCluster.clusterContext()).networkStatsListenerFactory().apply(engineCluster.clusterContext());
            ServerEndpoint serverEndpoint = new ServerEndpoint(connectUri, tree, networkStatsListener);
            tree.root().addView(ServerEndpoint.class, serverEndpoint);
            tree.registerSubscriber("", TopologicalEvent.class, e -> LOGGER.info("Tree change " + e));
            for (EngineHostDetails engineHostDetails : engineCluster.hostDetails()) {
                int id = engineHostDetails.hostId();
                Asset asset2 = tree.acquireAsset("/proc/connections/cluster/throughput/" + id);
                asset2.addView(new QueueConfig(x -> id, false, null, WireType.BINARY));
                tree.acquireQueue("/proc/connections/cluster/throughput/" + id, String.class, NetworkStats.class, engineCluster.clusterName());
            }
            return tree;
        }
        catch (Exception e3) {
            throw Jvm.rethrow((Throwable)e3);
        }
    }

    static String firstClusterName(@NotNull VanillaAssetTree tree) {
        Clusters clusters = tree.root().getView(Clusters.class);
        if (clusters == null) {
            return "";
        }
        EngineCluster engineCluster = clusters.firstCluster();
        if (engineCluster == null) {
            return "";
        }
        return engineCluster.clusterName();
    }

    static {
        try {
            Jvm.setExceptionsHandlers((ExceptionHandler)PrintExceptionHandler.WARN, (ExceptionHandler)PrintExceptionHandler.WARN, null);
            RequestContext.loadDefaultAliases();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

