/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.AbstractInvocationHandler;
import net.openhft.chronicle.core.util.GenericReflection;
import net.openhft.chronicle.core.util.IgnoresEverything;
import org.jetbrains.annotations.NotNull;

public final class Mocker {
    private static final Class<?>[] NO_CLASSES = new Class[0];

    private Mocker() {
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> interfaceType, String description, @NotNull PrintStream out) {
        return Mocker.intercepting(interfaceType, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> interfaceType, String description, @NotNull PrintWriter out) {
        return Mocker.intercepting(interfaceType, description, out::println);
    }

    @NotNull
    public static <T> T logging(@NotNull Class<T> interfaceType, String description, @NotNull StringWriter out) {
        return Mocker.logging(interfaceType, description, new PrintWriter(out));
    }

    @NotNull
    public static <T> T queuing(@NotNull Class<T> interfaceType, String description, @NotNull BlockingQueue<String> queue) {
        return Mocker.intercepting(interfaceType, description, queue::add);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> interfaceType, String description, @NotNull Consumer<String> consumer) {
        return Mocker.intercepting(interfaceType, description, consumer, null);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> interfaceType, @NotNull String description, @NotNull Consumer<String> consumer, T t) {
        return Mocker.intercepting(interfaceType, (String name, Object[] args) -> consumer.accept(description + name + (args == null ? "()" : Arrays.toString(args))), t);
    }

    @NotNull
    public static <T> T intercepting(@NotNull Class<T> interfaceType, final @NotNull BiConsumer<String, Object[]> consumer, final T t) {
        LinkedHashSet classes = new LinkedHashSet();
        Mocker.addInterface(classes, interfaceType);
        return (T)Mocker.newProxyInstance(interfaceType.getClassLoader(), classes.toArray(NO_CLASSES), new AbstractInvocationHandler(interfaceType){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
                consumer.accept(method.getName(), args);
                if (t != null) {
                    return method.invoke(t, args);
                }
                return null;
            }
        });
    }

    private static <T> void addInterface(Set<Class<?>> interfaceType, Class<T> tClass) {
        if (Jvm.dontChain(tClass)) {
            return;
        }
        if (interfaceType.contains(tClass)) {
            return;
        }
        interfaceType.add(tClass);
        for (Method method : tClass.getMethods()) {
            Class returnType;
            Type returnType0 = GenericReflection.getReturnType(method, tClass);
            if (!(returnType0 instanceof Class) || !(returnType = (Class)returnType0).isInterface()) continue;
            Mocker.addInterface(interfaceType, returnType);
        }
    }

    @NotNull
    public static <T> T ignored(@NotNull Class<T> interfaceType, Class<?> ... additional) {
        LinkedHashSet classes = new LinkedHashSet();
        Mocker.addInterface(classes, interfaceType);
        classes.add(interfaceType);
        for (Class<?> aClass : additional) {
            Mocker.addInterface(classes, aClass);
        }
        classes.add(IgnoresEverything.class);
        ClassLoader tClassLoader = interfaceType.getClassLoader();
        return (T)Mocker.newProxyInstance(tClassLoader != null ? tClassLoader : Mocker.class.getClassLoader(), classes.toArray(NO_CLASSES), new AbstractInvocationHandler(interfaceType){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) {
                return null;
            }
        });
    }

    private static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classes, AbstractInvocationHandler handler) {
        try {
            return Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException e) {
            return Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), classes, (InvocationHandler)handler);
        }
    }
}

