/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class MapUtil {
    private MapUtil() {
    }

    public static <K, V> Map.Entry<K, V> entry(@NotNull K key, @NotNull V value) {
        ObjectUtils.requireNonNull(key);
        ObjectUtils.requireNonNull(value);
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> ofUnmodifiable(Map.Entry<K, V> ... entries) {
        ObjectUtils.requireNonNull(entries);
        return Stream.of(entries).map(ObjectUtils::requireNonNull).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));
    }
}

