/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.threads.JitterSampler;

public class MonitorProfileAnalyserMain {
    private static final int MAX_LINES = Integer.getInteger("st.maxlines", 8);
    private static final String PROFILE_OF_THE_THREAD = "profile of the thread";
    private static final String THREAD_HAS_BLOCKED_FOR = "thread has blocked for";

    public static void main(String[] args) throws IOException {
        String stIgnore;
        if (args.length == 0) {
            System.err.println("No input file(s) provided");
        }
        List<String> ignoreSubStrings = (stIgnore = System.getProperty("st.ignore")) != null ? Arrays.asList(stIgnore.split(",")) : Collections.emptyList();
        int interval = Integer.getInteger("interval", 0);
        if (interval > 0) {
            while (true) {
                MonitorProfileAnalyserMain.main0(ignoreSubStrings, args);
                JitterSampler.sleepSilently(interval * 1000);
                System.out.println("\n---\n");
            }
        }
        MonitorProfileAnalyserMain.main0(ignoreSubStrings, args);
    }

    public static void main0(List<String> ignoreSubStrings, String[] args) throws IOException {
        System.out.println("Grouped by line");
        LinkedHashMap<String, Integer> stackCount = new LinkedHashMap<String, Integer>();
        for (String arg : args) {
            StringBuilder sb = new StringBuilder();
            int lineCount = -1;
            try (BufferedReader br = Files.newBufferedReader(Paths.get(arg, new String[0]));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.contains(PROFILE_OF_THE_THREAD) || line.contains(THREAD_HAS_BLOCKED_FOR)) {
                        if (sb.length() > 0) {
                            MonitorProfileAnalyserMain.addToStackCount(ignoreSubStrings, stackCount, sb);
                        }
                        lineCount = 0;
                        sb.setLength(0);
                        continue;
                    }
                    if (MonitorProfileAnalyserMain.partOfStackTrace(line) && lineCount >= 0) {
                        if (++lineCount > MAX_LINES) continue;
                        sb.append(line).append("\n");
                        continue;
                    }
                    if (sb.length() <= 0) continue;
                    MonitorProfileAnalyserMain.addToStackCount(ignoreSubStrings, stackCount, sb);
                    sb.setLength(0);
                }
            }
        }
        List stackSortedByCount = stackCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 2).sorted(Comparator.comparing(e -> -((Integer)e.getValue()).intValue())).limit(20L).collect(Collectors.toList());
        stackSortedByCount.stream().peek(e -> {
            Integer cfr_ignored_0 = (Integer)stackCount.remove(e.getKey());
        }).forEach(e -> System.out.println(e.getValue() + (String)e.getKey()));
        System.out.println("Grouped by method.");
        LinkedHashMap<String, Integer> methodCount = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : stackCount.entrySet()) {
            String stack = ((String)entry.getKey()).replaceFirst("\\(.*?\\)", "( * )");
            methodCount.compute(stack, (k, v) -> (v == null ? 0 : v) + (Integer)entry.getValue());
        }
        List<Map.Entry> methodSortedByCount = methodCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 2).sorted(Comparator.comparing(e -> -((Integer)e.getValue()).intValue())).limit(20L).collect(Collectors.toList());
        methodSortedByCount.forEach(e -> System.out.println(e.getValue() + (String)e.getKey()));
    }

    private static void addToStackCount(List<String> ignoreSubStrings, Map<String, Integer> stackCount, StringBuilder sb) {
        String lines = sb.toString();
        for (String ss : ignoreSubStrings) {
            if (!lines.contains(ss)) continue;
            return;
        }
        stackCount.compute(lines, (k, v) -> v == null ? 1 : v + 1);
    }

    private static boolean partOfStackTrace(String line) {
        return line.startsWith("\tat ") || line.matches("\\s+at .*");
    }
}

