/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;

public abstract class AbstractCloseableReferenceCounted
extends AbstractReferenceCounted
implements ManagedCloseable {
    private volatile transient boolean closed;
    private volatile transient StackTrace closedHere;
    private boolean initReleased;

    public AbstractCloseableReferenceCounted() {
        Set<Closeable> set = AbstractCloseable.CLOSEABLE_SET;
        if (set != null) {
            set.add(this);
        }
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.throwExceptionIfClosed();
        super.reserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.throwExceptionIfClosed();
        super.reserveTransfer(from, to);
        if (from == INIT) {
            this.initReleased = true;
        }
        if (to == INIT) {
            this.initReleased = false;
        }
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        super.release(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        super.releaseLast(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        return !this.closed && super.tryReserve(id);
    }

    @Override
    public void close() {
        if (!this.initReleased) {
            try {
                this.release(INIT);
            }
            catch (IllegalStateException e) {
                Jvm.warn().on(this.getClass(), "Failed to release LAST, closing anyway", e);
            }
        }
        this.setClosed();
    }

    protected void setClosed() {
        this.closed = true;
        this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + " closed here") : null;
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.closed) {
            throw new ClosedIllegalStateException(this.getClass().getName() + " closed", this.closedHere);
        }
        this.throwExceptionIfReleased();
        assert (this.threadSafetyCheck(true));
    }

    protected void throwExceptionIfClosedInSetter() throws IllegalStateException {
        if (this.closed) {
            throw new ClosedIllegalStateException(this.getClass().getName() + " closed", this.closedHere);
        }
        this.throwExceptionIfReleased();
        assert (this.threadSafetyCheck(false));
    }

    @Override
    public boolean isClosed() {
        return this.refCount() <= 0 || this.closed;
    }
}

